/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.jobQueue.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.Gs2JobQueueRestClient;
import io.gs2.jobQueue.domain.model.JobDomain;
import io.gs2.jobQueue.domain.model.JobResultAccessTokenDomain;
import io.gs2.jobQueue.domain.model.UserDomain;
import io.gs2.jobQueue.model.Job;

public class JobAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2JobQueueRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String jobName;
    private final String parentKey;
    Boolean isLastJob;

    public Boolean getIsLastJob() {
        return this.isLastJob;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String jobName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2JobQueueRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.jobName = jobName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Job");
    }

    public JobResultAccessTokenDomain jobResult(String tryNumber) {
        return new JobResultAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, this.jobName, tryNumber);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String jobName, String childType) {
        return String.join((CharSequence)":", "jobQueue", namespaceName, userId, jobName, childType);
    }

    public static String createCacheKey(String jobName) {
        return String.join((CharSequence)":", jobName);
    }

    public Job model() {
        Job value = this.cache.get(this.parentKey, JobDomain.createCacheKey(this.getJobName() != null ? this.getJobName().toString() : null), Job.class);
        return value;
    }
}

