/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.jobQueue.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.Gs2JobQueueRestClient;
import io.gs2.jobQueue.domain.model.UserDomain;
import io.gs2.jobQueue.model.DeadLetterJob;
import io.gs2.jobQueue.request.DeleteDeadLetterJobByUserIdRequest;
import io.gs2.jobQueue.request.GetDeadLetterJobByUserIdRequest;
import io.gs2.jobQueue.result.DeleteDeadLetterJobByUserIdResult;
import io.gs2.jobQueue.result.GetDeadLetterJobByUserIdResult;

public class DeadLetterJobDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2JobQueueRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String deadLetterJobName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDeadLetterJobName() {
        return this.deadLetterJobName;
    }

    public DeadLetterJobDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String deadLetterJobName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2JobQueueRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.deadLetterJobName = deadLetterJobName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "DeadLetterJob");
    }

    private DeadLetterJob get(GetDeadLetterJobByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withDeadLetterJobName(this.deadLetterJobName);
        GetDeadLetterJobByUserIdResult result = this.client.getDeadLetterJobByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DeadLetterJobDomain.createCacheKey(request.getDeadLetterJobName() != null ? request.getDeadLetterJobName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public DeadLetterJobDomain delete(DeleteDeadLetterJobByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withDeadLetterJobName(this.deadLetterJobName);
        DeleteDeadLetterJobByUserIdResult result = null;
        try {
            result = this.client.deleteDeadLetterJobByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, DeadLetterJobDomain.createCacheKey(request.getDeadLetterJobName() != null ? request.getDeadLetterJobName().toString() : null), DeadLetterJob.class);
        DeadLetterJobDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String deadLetterJobName, String childType) {
        return String.join((CharSequence)":", "jobQueue", namespaceName, userId, deadLetterJobName, childType);
    }

    public static String createCacheKey(String deadLetterJobName) {
        return String.join((CharSequence)":", deadLetterJobName);
    }

    public DeadLetterJob model() {
        DeadLetterJob value = this.cache.get(this.parentKey, DeadLetterJobDomain.createCacheKey(this.getDeadLetterJobName() != null ? this.getDeadLetterJobName().toString() : null), DeadLetterJob.class);
        if (value == null) {
            try {
                this.get(new GetDeadLetterJobByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, DeadLetterJobDomain.createCacheKey(this.getDeadLetterJobName() != null ? this.getDeadLetterJobName().toString() : null), DeadLetterJob.class);
            }
            value = this.cache.get(this.parentKey, DeadLetterJobDomain.createCacheKey(this.getDeadLetterJobName() != null ? this.getDeadLetterJobName().toString() : null), DeadLetterJob.class);
        }
        return value;
    }
}

