/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.jobQueue.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.Gs2JobQueueRestClient;
import io.gs2.jobQueue.domain.model.DeadLetterJobDomain;
import io.gs2.jobQueue.domain.model.UserDomain;
import io.gs2.jobQueue.model.DeadLetterJob;

public class DeadLetterJobAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2JobQueueRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String deadLetterJobName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getDeadLetterJobName() {
        return this.deadLetterJobName;
    }

    public DeadLetterJobAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String deadLetterJobName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2JobQueueRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.deadLetterJobName = deadLetterJobName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "DeadLetterJob");
    }

    public static String createCacheParentKey(String namespaceName, String userId, String deadLetterJobName, String childType) {
        return String.join((CharSequence)":", "jobQueue", namespaceName, userId, deadLetterJobName, childType);
    }

    public static String createCacheKey(String deadLetterJobName) {
        return String.join((CharSequence)":", deadLetterJobName);
    }

    public DeadLetterJob model() {
        DeadLetterJob value = this.cache.get(this.parentKey, DeadLetterJobDomain.createCacheKey(this.getDeadLetterJobName() != null ? this.getDeadLetterJobName().toString() : null), DeadLetterJob.class);
        return value;
    }
}

