/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.jobQueue.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.jobQueue.Gs2JobQueueRestClient;
import io.gs2.jobQueue.domain.model.JobDomain;
import io.gs2.jobQueue.domain.model.UserDomain;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.request.DescribeJobsByUserIdRequest;
import io.gs2.jobQueue.result.DescribeJobsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeJobsByUserIdIterator
implements Iterator<Job>,
Iterable<Job> {
    CacheDatabase cache;
    Gs2JobQueueRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<Job> result;
    Integer fetchSize;

    public DescribeJobsByUserIdIterator(CacheDatabase cache, Gs2JobQueueRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Job>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Job");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Job.class)) {
            this.result = this.cache.list(parentKey, Job.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeJobsByUserIdResult r = this.client.describeJobsByUserId(new DescribeJobsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Job item : this.result) {
                this.cache.put(parentKey, JobDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Job.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Job next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Job ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Job> iterator() {
        return this;
    }
}

