/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.model.InventoryModelDomain;
import io.gs2.inventory.model.ItemModel;
import io.gs2.inventory.request.GetItemModelRequest;
import io.gs2.inventory.result.GetItemModelResult;

public class ItemModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InventoryRestClient client;
    private final String namespaceName;
    private final String inventoryName;
    private final String itemName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public ItemModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String inventoryName, String itemName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InventoryRestClient(session);
        this.namespaceName = namespaceName;
        this.inventoryName = inventoryName;
        this.itemName = itemName;
        this.parentKey = InventoryModelDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemModel");
    }

    private ItemModel get(GetItemModelRequest request) {
        request.withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName).withItemName(this.itemName);
        GetItemModelResult result = this.client.getItemModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ItemModelDomain.createCacheKey(request.getItemName() != null ? request.getItemName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String inventoryName, String itemName, String childType) {
        return String.join((CharSequence)":", "inventory", namespaceName, inventoryName, itemName, childType);
    }

    public static String createCacheKey(String itemName) {
        return String.join((CharSequence)":", itemName);
    }

    public ItemModel model() {
        ItemModel value = this.cache.get(this.parentKey, ItemModelDomain.createCacheKey(this.getItemName() != null ? this.getItemName().toString() : null), ItemModel.class);
        if (value == null) {
            try {
                this.get(new GetItemModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ItemModelDomain.createCacheKey(this.getItemName() != null ? this.getItemName().toString() : null), ItemModel.class);
            }
            value = this.cache.get(this.parentKey, ItemModelDomain.createCacheKey(this.getItemName() != null ? this.getItemName().toString() : null), ItemModel.class);
        }
        return value;
    }
}

