/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.iterator.DescribeItemModelMastersIterator;
import io.gs2.inventory.domain.model.ItemModelMasterDomain;
import io.gs2.inventory.domain.model.NamespaceDomain;
import io.gs2.inventory.model.InventoryModelMaster;
import io.gs2.inventory.request.CreateItemModelMasterRequest;
import io.gs2.inventory.request.DeleteInventoryModelMasterRequest;
import io.gs2.inventory.request.GetInventoryModelMasterRequest;
import io.gs2.inventory.request.UpdateInventoryModelMasterRequest;
import io.gs2.inventory.result.CreateItemModelMasterResult;
import io.gs2.inventory.result.DeleteInventoryModelMasterResult;
import io.gs2.inventory.result.GetInventoryModelMasterResult;
import io.gs2.inventory.result.UpdateInventoryModelMasterResult;

public class InventoryModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InventoryRestClient client;
    private final String namespaceName;
    private final String inventoryName;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public InventoryModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String inventoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InventoryRestClient(session);
        this.namespaceName = namespaceName;
        this.inventoryName = inventoryName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "InventoryModelMaster");
    }

    private InventoryModelMaster get(GetInventoryModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName);
        GetInventoryModelMasterResult result = this.client.getInventoryModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, InventoryModelMasterDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public InventoryModelMasterDomain update(UpdateInventoryModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName);
        UpdateInventoryModelMasterResult result = this.client.updateInventoryModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, InventoryModelMasterDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        InventoryModelMasterDomain domain = this;
        return domain;
    }

    public InventoryModelMasterDomain delete(DeleteInventoryModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName);
        DeleteInventoryModelMasterResult result = null;
        try {
            result = this.client.deleteInventoryModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, InventoryModelMasterDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), InventoryModelMaster.class);
        InventoryModelMasterDomain domain = this;
        return domain;
    }

    public ItemModelMasterDomain createItemModelMaster(CreateItemModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName);
        CreateItemModelMasterResult result = this.client.createItemModelMaster(request);
        String parentKey = InventoryModelMasterDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ItemModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ItemModelMasterDomain domain = new ItemModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getInventoryName(), result.getItem().getName());
        return domain;
    }

    public DescribeItemModelMastersIterator itemModelMasters() {
        return new DescribeItemModelMastersIterator(this.cache, this.client, this.namespaceName, this.inventoryName);
    }

    public ItemModelMasterDomain itemModelMaster(String itemName) {
        return new ItemModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.inventoryName, itemName);
    }

    public static String createCacheParentKey(String namespaceName, String inventoryName, String childType) {
        return String.join((CharSequence)":", "inventory", namespaceName, inventoryName, childType);
    }

    public static String createCacheKey(String inventoryName) {
        return String.join((CharSequence)":", inventoryName);
    }

    public InventoryModelMaster model() {
        InventoryModelMaster value = this.cache.get(this.parentKey, InventoryModelMasterDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), InventoryModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetInventoryModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, InventoryModelMasterDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), InventoryModelMaster.class);
            }
            value = this.cache.get(this.parentKey, InventoryModelMasterDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), InventoryModelMaster.class);
        }
        return value;
    }
}

