/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.iterator.DescribeItemSetsIterator;
import io.gs2.inventory.domain.model.InventoryDomain;
import io.gs2.inventory.domain.model.ItemSetAccessTokenDomain;
import io.gs2.inventory.domain.model.UserDomain;
import io.gs2.inventory.model.Inventory;
import io.gs2.inventory.request.GetInventoryRequest;
import io.gs2.inventory.result.GetInventoryResult;

public class InventoryAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InventoryRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String inventoryName;
    private final String parentKey;
    Long overflowCount;
    String nextPageToken;

    public Long getOverflowCount() {
        return this.overflowCount;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public InventoryAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String inventoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InventoryRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.inventoryName = inventoryName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Inventory");
    }

    private Inventory get(GetInventoryRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withInventoryName(this.inventoryName);
        GetInventoryResult result = this.client.getInventory(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, InventoryDomain.createCacheKey(request.getInventoryName() != null ? request.getInventoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public DescribeItemSetsIterator itemSets() {
        return new DescribeItemSetsIterator(this.cache, this.client, this.namespaceName, this.inventoryName, this.accessToken);
    }

    public ItemSetAccessTokenDomain itemSet(String itemName, String itemSetName) {
        return new ItemSetAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, this.inventoryName, itemName, itemSetName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String inventoryName, String childType) {
        return String.join((CharSequence)":", "inventory", namespaceName, userId, inventoryName, childType);
    }

    public static String createCacheKey(String inventoryName) {
        return String.join((CharSequence)":", inventoryName);
    }

    public Inventory model() {
        Inventory value = this.cache.get(this.parentKey, InventoryDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), Inventory.class);
        if (value == null) {
            try {
                this.get(new GetInventoryRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, InventoryDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), Inventory.class);
            }
            value = this.cache.get(this.parentKey, InventoryDomain.createCacheKey(this.getInventoryName() != null ? this.getInventoryName().toString() : null), Inventory.class);
        }
        return value;
    }
}

