/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.model.NamespaceDomain;
import io.gs2.inventory.model.CurrentItemModelMaster;
import io.gs2.inventory.request.ExportMasterRequest;
import io.gs2.inventory.request.GetCurrentItemModelMasterRequest;
import io.gs2.inventory.request.UpdateCurrentItemModelMasterFromGitHubRequest;
import io.gs2.inventory.request.UpdateCurrentItemModelMasterRequest;
import io.gs2.inventory.result.ExportMasterResult;
import io.gs2.inventory.result.GetCurrentItemModelMasterResult;
import io.gs2.inventory.result.UpdateCurrentItemModelMasterFromGitHubResult;
import io.gs2.inventory.result.UpdateCurrentItemModelMasterResult;

public class CurrentItemModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InventoryRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentItemModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InventoryRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentItemModelMaster");
    }

    public CurrentItemModelMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentItemModelMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentItemModelMasterDomain domain = this;
        return domain;
    }

    private CurrentItemModelMaster get(GetCurrentItemModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentItemModelMasterResult result = this.client.getCurrentItemModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentItemModelMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentItemModelMasterDomain update(UpdateCurrentItemModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentItemModelMasterResult result = this.client.updateCurrentItemModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentItemModelMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentItemModelMasterDomain domain = this;
        return domain;
    }

    public CurrentItemModelMasterDomain updateFromGitHub(UpdateCurrentItemModelMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentItemModelMasterFromGitHubResult result = this.client.updateCurrentItemModelMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentItemModelMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentItemModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "inventory", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentItemModelMaster model() {
        CurrentItemModelMaster value = this.cache.get(this.parentKey, CurrentItemModelMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentItemModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentItemModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentItemModelMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentItemModelMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentItemModelMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentItemModelMaster.class);
        }
        return value;
    }
}

