/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.model.InventoryDomain;
import io.gs2.inventory.domain.model.ItemSetDomain;
import io.gs2.inventory.model.ItemSet;
import io.gs2.inventory.request.DescribeItemSetsRequest;
import io.gs2.inventory.result.DescribeItemSetsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeItemSetsIterator
implements Iterator<ItemSet>,
Iterable<ItemSet> {
    CacheDatabase cache;
    Gs2InventoryRestClient client;
    String namespaceName;
    String inventoryName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<ItemSet> result;
    Integer fetchSize;

    public DescribeItemSetsIterator(CacheDatabase cache, Gs2InventoryRestClient client, String namespaceName, String inventoryName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.inventoryName = inventoryName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<ItemSet>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = InventoryDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemSet");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, ItemSet.class)) {
            this.result = this.cache.list(parentKey, ItemSet.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeItemSetsResult r = this.client.describeItemSets(new DescribeItemSetsRequest().withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (ItemSet item : this.result) {
                this.cache.put(parentKey, ItemSetDomain.createCacheKey(item.getItemName() != null ? item.getItemName().toString() : null, item.getName() != null ? item.getName().toString() : null), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
            }
            if (this.last) {
                this.cache.listCached(listParentKey, ItemSet.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public ItemSet next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        ItemSet ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<ItemSet> iterator() {
        return this;
    }
}

