/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.model.InventoryModelDomain;
import io.gs2.inventory.domain.model.ItemModelDomain;
import io.gs2.inventory.model.ItemModel;
import io.gs2.inventory.request.DescribeItemModelsRequest;
import io.gs2.inventory.result.DescribeItemModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeItemModelsIterator
implements Iterator<ItemModel>,
Iterable<ItemModel> {
    CacheDatabase cache;
    Gs2InventoryRestClient client;
    String namespaceName;
    String inventoryName;
    boolean last;
    List<ItemModel> result;
    Integer fetchSize;

    public DescribeItemModelsIterator(CacheDatabase cache, Gs2InventoryRestClient client, String namespaceName, String inventoryName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.inventoryName = inventoryName;
        this.last = false;
        this.result = new ArrayList<ItemModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = InventoryModelDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.inventoryName != null ? this.inventoryName.toString() : null, "ItemModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, ItemModel.class)) {
            this.result = this.cache.list(parentKey, ItemModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeItemModelsResult r = this.client.describeItemModels(new DescribeItemModelsRequest().withNamespaceName(this.namespaceName).withInventoryName(this.inventoryName));
            this.result = r.getItems();
            this.last = true;
            for (ItemModel item : this.result) {
                this.cache.put(parentKey, ItemModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, ItemModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public ItemModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        ItemModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<ItemModel> iterator() {
        return this;
    }
}

