/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inventory.Gs2InventoryRestClient;
import io.gs2.inventory.domain.model.InventoryModelMasterDomain;
import io.gs2.inventory.domain.model.NamespaceDomain;
import io.gs2.inventory.model.InventoryModelMaster;
import io.gs2.inventory.request.DescribeInventoryModelMastersRequest;
import io.gs2.inventory.result.DescribeInventoryModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeInventoryModelMastersIterator
implements Iterator<InventoryModelMaster>,
Iterable<InventoryModelMaster> {
    CacheDatabase cache;
    Gs2InventoryRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<InventoryModelMaster> result;
    Integer fetchSize;

    public DescribeInventoryModelMastersIterator(CacheDatabase cache, Gs2InventoryRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<InventoryModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "InventoryModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, InventoryModelMaster.class)) {
            this.result = this.cache.list(parentKey, InventoryModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeInventoryModelMastersResult r = this.client.describeInventoryModelMasters(new DescribeInventoryModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (InventoryModelMaster item : this.result) {
                this.cache.put(parentKey, InventoryModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, InventoryModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public InventoryModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        InventoryModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<InventoryModelMaster> iterator() {
        return this;
    }
}

