/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inbox.Gs2InboxRestClient;
import io.gs2.inbox.domain.iterator.DescribeMessagesIterator;
import io.gs2.inbox.domain.model.MessageAccessTokenDomain;
import io.gs2.inbox.domain.model.MessageDomain;
import io.gs2.inbox.domain.model.NamespaceDomain;
import io.gs2.inbox.domain.model.ReceivedAccessTokenDomain;
import io.gs2.inbox.domain.model.ReceivedDomain;
import io.gs2.inbox.domain.model.UserDomain;
import io.gs2.inbox.model.Message;
import io.gs2.inbox.model.Received;
import io.gs2.inbox.request.ReceiveGlobalMessageRequest;
import io.gs2.inbox.result.ReceiveGlobalMessageResult;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InboxRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InboxRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public MessageAccessTokenDomain[] receiveGlobalMessage(ReceiveGlobalMessageRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        ReceiveGlobalMessageResult result = this.client.receiveGlobalMessage(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Message");
        for (Message item : result.getItem()) {
            if (item == null) continue;
            this.cache.put(parentKey, MessageDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
        }
        this.cache.delete(UserDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.getUserId() != null ? this.getUserId().toString() : null, "Received"), ReceivedDomain.createCacheKey(), Received.class);
        MessageAccessTokenDomain[] domain = new MessageAccessTokenDomain[result.getItem().size()];
        for (int i = 0; i < result.getItem().size(); ++i) {
            domain[i] = new MessageAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, result.getItem().get(i).getName());
        }
        return domain;
    }

    public DescribeMessagesIterator messages() {
        return new DescribeMessagesIterator(this.cache, this.client, this.namespaceName, this.accessToken);
    }

    public MessageAccessTokenDomain message(String messageName) {
        return new MessageAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, messageName);
    }

    public ReceivedAccessTokenDomain received() {
        return new ReceivedAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "inbox", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

