/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inbox.Gs2InboxRestClient;
import io.gs2.inbox.domain.model.UserDomain;
import io.gs2.inbox.model.Received;
import io.gs2.inbox.request.DeleteReceivedByUserIdRequest;
import io.gs2.inbox.request.GetReceivedByUserIdRequest;
import io.gs2.inbox.request.UpdateReceivedByUserIdRequest;
import io.gs2.inbox.result.DeleteReceivedByUserIdResult;
import io.gs2.inbox.result.GetReceivedByUserIdResult;
import io.gs2.inbox.result.UpdateReceivedByUserIdResult;

public class ReceivedDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InboxRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public ReceivedDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InboxRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Received");
    }

    private Received get(GetReceivedByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        GetReceivedByUserIdResult result = this.client.getReceivedByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ReceivedDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ReceivedDomain update(UpdateReceivedByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        UpdateReceivedByUserIdResult result = this.client.updateReceivedByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ReceivedDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ReceivedDomain domain = this;
        return domain;
    }

    public ReceivedDomain delete(DeleteReceivedByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        DeleteReceivedByUserIdResult result = null;
        try {
            result = this.client.deleteReceivedByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, ReceivedDomain.createCacheKey(), Received.class);
        ReceivedDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "inbox", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public Received model() {
        Received value = this.cache.get(this.parentKey, ReceivedDomain.createCacheKey(), Received.class);
        if (value == null) {
            try {
                this.get(new GetReceivedByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ReceivedDomain.createCacheKey(), Received.class);
            }
            value = this.cache.get(this.parentKey, ReceivedDomain.createCacheKey(), Received.class);
        }
        return value;
    }
}

