/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inbox.Gs2InboxRestClient;
import io.gs2.inbox.domain.model.UserDomain;
import io.gs2.inbox.model.Message;
import io.gs2.inbox.request.DeleteMessageByUserIdRequest;
import io.gs2.inbox.request.GetMessageByUserIdRequest;
import io.gs2.inbox.request.OpenMessageByUserIdRequest;
import io.gs2.inbox.request.ReadMessageByUserIdRequest;
import io.gs2.inbox.result.DeleteMessageByUserIdResult;
import io.gs2.inbox.result.GetMessageByUserIdResult;
import io.gs2.inbox.result.OpenMessageByUserIdResult;
import io.gs2.inbox.result.ReadMessageByUserIdResult;

public class MessageDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InboxRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String messageName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public MessageDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String messageName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InboxRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.messageName = messageName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Message");
    }

    private Message get(GetMessageByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMessageName(this.messageName);
        GetMessageByUserIdResult result = this.client.getMessageByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MessageDomain.createCacheKey(request.getMessageName() != null ? request.getMessageName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        return result.getItem();
    }

    public MessageDomain open(OpenMessageByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMessageName(this.messageName);
        OpenMessageByUserIdResult result = this.client.openMessageByUserId(request);
        this.cache.listCacheClear(this.parentKey.replace("Message", "Message"), Message.class);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MessageDomain.createCacheKey(request.getMessageName() != null ? request.getMessageName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        MessageDomain domain = this;
        return domain;
    }

    public StampSheetDomain read(ReadMessageByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMessageName(this.messageName);
        ReadMessageByUserIdResult result = this.client.readMessageByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MessageDomain.createCacheKey(request.getMessageName() != null ? request.getMessageName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public MessageDomain delete(DeleteMessageByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMessageName(this.messageName);
        DeleteMessageByUserIdResult result = null;
        try {
            result = this.client.deleteMessageByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MessageDomain.createCacheKey(request.getMessageName() != null ? request.getMessageName().toString() : null), Message.class);
        MessageDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String messageName, String childType) {
        return String.join((CharSequence)":", "inbox", namespaceName, userId, messageName, childType);
    }

    public static String createCacheKey(String messageName) {
        return String.join((CharSequence)":", messageName);
    }

    public Message model() {
        Message value = this.cache.get(this.parentKey, MessageDomain.createCacheKey(this.getMessageName() != null ? this.getMessageName().toString() : null), Message.class);
        if (value == null) {
            try {
                this.get(new GetMessageByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MessageDomain.createCacheKey(this.getMessageName() != null ? this.getMessageName().toString() : null), Message.class);
            }
            value = this.cache.get(this.parentKey, MessageDomain.createCacheKey(this.getMessageName() != null ? this.getMessageName().toString() : null), Message.class);
        }
        return value;
    }
}

