/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inbox.Gs2InboxRestClient;
import io.gs2.inbox.domain.model.MessageDomain;
import io.gs2.inbox.domain.model.UserDomain;
import io.gs2.inbox.model.Message;
import io.gs2.inbox.request.DeleteMessageRequest;
import io.gs2.inbox.request.GetMessageRequest;
import io.gs2.inbox.request.OpenMessageRequest;
import io.gs2.inbox.request.ReadMessageRequest;
import io.gs2.inbox.result.DeleteMessageResult;
import io.gs2.inbox.result.GetMessageResult;
import io.gs2.inbox.result.OpenMessageResult;
import io.gs2.inbox.result.ReadMessageResult;

public class MessageAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InboxRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String messageName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getMessageName() {
        return this.messageName;
    }

    public MessageAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String messageName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InboxRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.messageName = messageName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Message");
    }

    private Message get(GetMessageRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMessageName(this.messageName);
        GetMessageResult result = this.client.getMessage(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MessageDomain.createCacheKey(request.getMessageName() != null ? request.getMessageName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        return result.getItem();
    }

    public MessageAccessTokenDomain open(OpenMessageRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMessageName(this.messageName);
        OpenMessageResult result = this.client.openMessage(request);
        this.cache.listCacheClear(this.parentKey.replace("Message", "Message"), Message.class);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MessageDomain.createCacheKey(request.getMessageName() != null ? request.getMessageName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        MessageAccessTokenDomain domain = this;
        return domain;
    }

    public StampSheetDomain read(ReadMessageRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMessageName(this.messageName);
        ReadMessageResult result = this.client.readMessage(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MessageDomain.createCacheKey(request.getMessageName() != null ? request.getMessageName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public MessageAccessTokenDomain delete(DeleteMessageRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMessageName(this.messageName);
        DeleteMessageResult result = null;
        try {
            result = this.client.deleteMessage(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MessageDomain.createCacheKey(request.getMessageName() != null ? request.getMessageName().toString() : null), Message.class);
        MessageAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String messageName, String childType) {
        return String.join((CharSequence)":", "inbox", namespaceName, userId, messageName, childType);
    }

    public static String createCacheKey(String messageName) {
        return String.join((CharSequence)":", messageName);
    }

    public Message model() {
        Message value = this.cache.get(this.parentKey, MessageDomain.createCacheKey(this.getMessageName() != null ? this.getMessageName().toString() : null), Message.class);
        if (value == null) {
            try {
                this.get(new GetMessageRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MessageDomain.createCacheKey(this.getMessageName() != null ? this.getMessageName().toString() : null), Message.class);
            }
            value = this.cache.get(this.parentKey, MessageDomain.createCacheKey(this.getMessageName() != null ? this.getMessageName().toString() : null), Message.class);
        }
        return value;
    }
}

