/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inbox.Gs2InboxRestClient;
import io.gs2.inbox.domain.model.NamespaceDomain;
import io.gs2.inbox.model.GlobalMessage;
import io.gs2.inbox.request.GetGlobalMessageRequest;
import io.gs2.inbox.result.GetGlobalMessageResult;

public class GlobalMessageDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InboxRestClient client;
    private final String namespaceName;
    private final String globalMessageName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getGlobalMessageName() {
        return this.globalMessageName;
    }

    public GlobalMessageDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String globalMessageName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InboxRestClient(session);
        this.namespaceName = namespaceName;
        this.globalMessageName = globalMessageName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "GlobalMessage");
    }

    private GlobalMessage get(GetGlobalMessageRequest request) {
        request.withNamespaceName(this.namespaceName).withGlobalMessageName(this.globalMessageName);
        GetGlobalMessageResult result = this.client.getGlobalMessage(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, GlobalMessageDomain.createCacheKey(request.getGlobalMessageName() != null ? request.getGlobalMessageName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String globalMessageName, String childType) {
        return String.join((CharSequence)":", "inbox", namespaceName, globalMessageName, childType);
    }

    public static String createCacheKey(String globalMessageName) {
        return String.join((CharSequence)":", globalMessageName);
    }

    public GlobalMessage model() {
        GlobalMessage value = this.cache.get(this.parentKey, GlobalMessageDomain.createCacheKey(this.getGlobalMessageName() != null ? this.getGlobalMessageName().toString() : null), GlobalMessage.class);
        if (value == null) {
            try {
                this.get(new GetGlobalMessageRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, GlobalMessageDomain.createCacheKey(this.getGlobalMessageName() != null ? this.getGlobalMessageName().toString() : null), GlobalMessage.class);
            }
            value = this.cache.get(this.parentKey, GlobalMessageDomain.createCacheKey(this.getGlobalMessageName() != null ? this.getGlobalMessageName().toString() : null), GlobalMessage.class);
        }
        return value;
    }
}

