/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.inbox.Gs2InboxRestClient;
import io.gs2.inbox.domain.model.NamespaceDomain;
import io.gs2.inbox.model.CurrentMessageMaster;
import io.gs2.inbox.request.ExportMasterRequest;
import io.gs2.inbox.request.GetCurrentMessageMasterRequest;
import io.gs2.inbox.request.UpdateCurrentMessageMasterFromGitHubRequest;
import io.gs2.inbox.request.UpdateCurrentMessageMasterRequest;
import io.gs2.inbox.result.ExportMasterResult;
import io.gs2.inbox.result.GetCurrentMessageMasterResult;
import io.gs2.inbox.result.UpdateCurrentMessageMasterFromGitHubResult;
import io.gs2.inbox.result.UpdateCurrentMessageMasterResult;

public class CurrentMessageMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2InboxRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentMessageMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2InboxRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentMessageMaster");
    }

    public CurrentMessageMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentMessageMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentMessageMasterDomain domain = this;
        return domain;
    }

    private CurrentMessageMaster get(GetCurrentMessageMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentMessageMasterResult result = this.client.getCurrentMessageMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentMessageMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentMessageMasterDomain update(UpdateCurrentMessageMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentMessageMasterResult result = this.client.updateCurrentMessageMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentMessageMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentMessageMasterDomain domain = this;
        return domain;
    }

    public CurrentMessageMasterDomain updateFromGitHub(UpdateCurrentMessageMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentMessageMasterFromGitHubResult result = this.client.updateCurrentMessageMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentMessageMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentMessageMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "inbox", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentMessageMaster model() {
        CurrentMessageMaster value = this.cache.get(this.parentKey, CurrentMessageMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentMessageMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentMessageMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentMessageMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentMessageMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentMessageMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentMessageMaster.class);
        }
        return value;
    }
}

