/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inbox.Gs2InboxRestClient;
import io.gs2.inbox.domain.model.MessageDomain;
import io.gs2.inbox.domain.model.UserDomain;
import io.gs2.inbox.model.Message;
import io.gs2.inbox.request.DescribeMessagesRequest;
import io.gs2.inbox.result.DescribeMessagesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeMessagesIterator
implements Iterator<Message>,
Iterable<Message> {
    CacheDatabase cache;
    Gs2InboxRestClient client;
    String namespaceName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<Message> result;
    Integer fetchSize;

    public DescribeMessagesIterator(CacheDatabase cache, Gs2InboxRestClient client, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Message>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Message");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Message.class)) {
            this.result = this.cache.list(parentKey, Message.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeMessagesResult r = this.client.describeMessages(new DescribeMessagesRequest().withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Message item : this.result) {
                this.cache.put(parentKey, MessageDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Message.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Message next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Message ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Message> iterator() {
        return this;
    }
}

