/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.inbox.Gs2InboxRestClient;
import io.gs2.inbox.domain.model.GlobalMessageMasterDomain;
import io.gs2.inbox.domain.model.NamespaceDomain;
import io.gs2.inbox.model.GlobalMessageMaster;
import io.gs2.inbox.request.DescribeGlobalMessageMastersRequest;
import io.gs2.inbox.result.DescribeGlobalMessageMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeGlobalMessageMastersIterator
implements Iterator<GlobalMessageMaster>,
Iterable<GlobalMessageMaster> {
    CacheDatabase cache;
    Gs2InboxRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<GlobalMessageMaster> result;
    Integer fetchSize;

    public DescribeGlobalMessageMastersIterator(CacheDatabase cache, Gs2InboxRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<GlobalMessageMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "GlobalMessageMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, GlobalMessageMaster.class)) {
            this.result = this.cache.list(parentKey, GlobalMessageMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeGlobalMessageMastersResult r = this.client.describeGlobalMessageMasters(new DescribeGlobalMessageMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (GlobalMessageMaster item : this.result) {
                this.cache.put(parentKey, GlobalMessageMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, GlobalMessageMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public GlobalMessageMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        GlobalMessageMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<GlobalMessageMaster> iterator() {
        return this;
    }
}

