/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.identifier.Gs2IdentifierRestClient;
import io.gs2.identifier.domain.iterator.DescribeIdentifiersIterator;
import io.gs2.identifier.domain.iterator.DescribePasswordsIterator;
import io.gs2.identifier.domain.model.AttachSecurityPolicyDomain;
import io.gs2.identifier.domain.model.IdentifierDomain;
import io.gs2.identifier.domain.model.PasswordDomain;
import io.gs2.identifier.model.User;
import io.gs2.identifier.request.CreateIdentifierRequest;
import io.gs2.identifier.request.DeleteUserRequest;
import io.gs2.identifier.request.GetUserRequest;
import io.gs2.identifier.request.UpdateUserRequest;
import io.gs2.identifier.result.CreateIdentifierResult;
import io.gs2.identifier.result.DeleteUserResult;
import io.gs2.identifier.result.GetUserResult;
import io.gs2.identifier.result.UpdateUserResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2IdentifierRestClient client;
    private final String userName;
    private final String parentKey;
    String clientSecret;
    String nextPageToken;

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getUserName() {
        return this.userName;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String userName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2IdentifierRestClient(session);
        this.userName = userName;
        this.parentKey = "identifier:User";
    }

    public UserDomain update(UpdateUserRequest request) {
        request.withUserName(this.userName);
        UpdateUserResult result = this.client.updateUser(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, UserDomain.createCacheKey(request.getUserName() != null ? request.getUserName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        UserDomain domain = this;
        return domain;
    }

    private User get(GetUserRequest request) {
        request.withUserName(this.userName);
        GetUserResult result = this.client.getUser(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, UserDomain.createCacheKey(request.getUserName() != null ? request.getUserName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public UserDomain delete(DeleteUserRequest request) {
        request.withUserName(this.userName);
        DeleteUserResult result = null;
        try {
            result = this.client.deleteUser(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, UserDomain.createCacheKey(request.getUserName() != null ? request.getUserName().toString() : null), User.class);
        UserDomain domain = this;
        return domain;
    }

    public IdentifierDomain createIdentifier(CreateIdentifierRequest request) {
        request.withUserName(this.userName);
        CreateIdentifierResult result = this.client.createIdentifier(request);
        String parentKey = UserDomain.createCacheParentKey(this.userName != null ? this.userName.toString() : null, "Identifier");
        if (result.getItem() != null) {
            this.cache.put(parentKey, IdentifierDomain.createCacheKey(request.getUserName() != null ? request.getUserName().toString() : null, result.getItem().getClientId() != null ? result.getItem().getClientId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        IdentifierDomain domain = new IdentifierDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getUserName(), result.getItem().getClientId());
        domain.clientSecret = result.getClientSecret();
        return domain;
    }

    public DescribeIdentifiersIterator identifiers() {
        return new DescribeIdentifiersIterator(this.cache, this.client, this.userName);
    }

    public IdentifierDomain identifier(String clientId) {
        return new IdentifierDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.userName, clientId);
    }

    public DescribePasswordsIterator passwords() {
        return new DescribePasswordsIterator(this.cache, this.client, this.userName);
    }

    public PasswordDomain password() {
        return new PasswordDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.userName);
    }

    public AttachSecurityPolicyDomain attachSecurityPolicy() {
        return new AttachSecurityPolicyDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.userName);
    }

    public static String createCacheParentKey(String userName, String childType) {
        return String.join((CharSequence)":", "identifier", userName, childType);
    }

    public static String createCacheKey(String userName) {
        return String.join((CharSequence)":", userName);
    }

    public User model() {
        User value = this.cache.get(this.parentKey, UserDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null), User.class);
        if (value == null) {
            try {
                this.get(new GetUserRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, UserDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null), User.class);
            }
            value = this.cache.get(this.parentKey, UserDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null), User.class);
        }
        return value;
    }
}

