/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.identifier.Gs2IdentifierRestClient;
import io.gs2.identifier.model.ProjectToken;
import io.gs2.identifier.request.LoginByUserRequest;
import io.gs2.identifier.request.LoginRequest;
import io.gs2.identifier.result.LoginByUserResult;
import io.gs2.identifier.result.LoginResult;

public class ProjectTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2IdentifierRestClient client;
    private final String parentKey;
    String accessToken;
    String tokenType;
    Integer expiresIn;

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public ProjectTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2IdentifierRestClient(session);
        this.parentKey = "identifier:ProjectToken";
    }

    public ProjectTokenDomain login(LoginRequest request) {
        LoginResult result = this.client.login(request);
        ProjectTokenDomain domain = this;
        this.accessToken = result.getAccessToken();
        this.tokenType = result.getTokenType();
        this.expiresIn = result.getExpiresIn();
        return domain;
    }

    public ProjectTokenDomain loginByUser(LoginByUserRequest request) {
        LoginByUserResult result = this.client.loginByUser(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProjectTokenDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ProjectTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String childType) {
        return String.join((CharSequence)":", "identifier", childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public ProjectToken model() {
        ProjectToken value = this.cache.get(this.parentKey, ProjectTokenDomain.createCacheKey(), ProjectToken.class);
        return value;
    }
}

