/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.identifier.Gs2IdentifierRestClient;
import io.gs2.identifier.domain.model.UserDomain;
import io.gs2.identifier.model.Identifier;
import io.gs2.identifier.request.DeleteIdentifierRequest;
import io.gs2.identifier.request.GetIdentifierRequest;
import io.gs2.identifier.result.DeleteIdentifierResult;
import io.gs2.identifier.result.GetIdentifierResult;

public class IdentifierDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2IdentifierRestClient client;
    private final String userName;
    private final String clientId;
    private final String parentKey;
    String clientSecret;

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public IdentifierDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String userName, String clientId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2IdentifierRestClient(session);
        this.userName = userName;
        this.clientId = clientId;
        this.parentKey = UserDomain.createCacheParentKey(this.userName != null ? this.userName.toString() : null, "Identifier");
    }

    private Identifier get(GetIdentifierRequest request) {
        request.withUserName(this.userName).withClientId(this.clientId);
        GetIdentifierResult result = this.client.getIdentifier(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, IdentifierDomain.createCacheKey(request.getUserName() != null ? request.getUserName().toString() : null, request.getClientId() != null ? request.getClientId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public IdentifierDomain delete(DeleteIdentifierRequest request) {
        request.withUserName(this.userName).withClientId(this.clientId);
        DeleteIdentifierResult result = null;
        try {
            result = this.client.deleteIdentifier(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, IdentifierDomain.createCacheKey(request.getUserName() != null ? request.getUserName().toString() : null, request.getClientId() != null ? request.getClientId().toString() : null), Identifier.class);
        IdentifierDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String userName, String clientId, String childType) {
        return String.join((CharSequence)":", "identifier", userName, clientId, childType);
    }

    public static String createCacheKey(String userName, String clientId) {
        return String.join((CharSequence)":", userName, clientId);
    }

    public Identifier model() {
        Identifier value = this.cache.get(this.parentKey, IdentifierDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null, this.getClientId() != null ? this.getClientId().toString() : null), Identifier.class);
        if (value == null) {
            try {
                this.get(new GetIdentifierRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, IdentifierDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null, this.getClientId() != null ? this.getClientId().toString() : null), Identifier.class);
            }
            value = this.cache.get(this.parentKey, IdentifierDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null, this.getClientId() != null ? this.getClientId().toString() : null), Identifier.class);
        }
        return value;
    }
}

