/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.identifier.Gs2IdentifierRestClient;
import io.gs2.identifier.domain.model.SecurityPolicyDomain;
import io.gs2.identifier.domain.model.UserDomain;
import io.gs2.identifier.model.AttachSecurityPolicy;
import io.gs2.identifier.model.SecurityPolicy;
import io.gs2.identifier.request.AttachSecurityPolicyRequest;
import io.gs2.identifier.request.DetachSecurityPolicyRequest;
import io.gs2.identifier.request.GetHasSecurityPolicyRequest;
import io.gs2.identifier.result.AttachSecurityPolicyResult;
import io.gs2.identifier.result.DetachSecurityPolicyResult;
import io.gs2.identifier.result.GetHasSecurityPolicyResult;

public class AttachSecurityPolicyDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2IdentifierRestClient client;
    private final String userName;
    private final String parentKey;

    public String getUserName() {
        return this.userName;
    }

    public AttachSecurityPolicyDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String userName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2IdentifierRestClient(session);
        this.userName = userName;
        this.parentKey = UserDomain.createCacheParentKey(this.userName != null ? this.userName.toString() : null, "AttachSecurityPolicy");
    }

    public SecurityPolicyDomain[] getHasSecurityPolicy(GetHasSecurityPolicyRequest request) {
        request.withUserName(this.userName);
        GetHasSecurityPolicyResult result = this.client.getHasSecurityPolicy(request);
        String parentKey = "identifier:SecurityPolicy";
        for (SecurityPolicy item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, SecurityPolicyDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SecurityPolicyDomain[] domain = new SecurityPolicyDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new SecurityPolicyDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItems().get(i).getName());
        }
        return domain;
    }

    public SecurityPolicyDomain[] attachSecurityPolicy(AttachSecurityPolicyRequest request) {
        request.withUserName(this.userName);
        AttachSecurityPolicyResult result = this.client.attachSecurityPolicy(request);
        String parentKey = "identifier:SecurityPolicy";
        for (SecurityPolicy item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, SecurityPolicyDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SecurityPolicyDomain[] domain = new SecurityPolicyDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new SecurityPolicyDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItems().get(i).getName());
        }
        return domain;
    }

    public SecurityPolicyDomain[] detachSecurityPolicy(DetachSecurityPolicyRequest request) {
        request.withUserName(this.userName);
        DetachSecurityPolicyResult result = this.client.detachSecurityPolicy(request);
        String parentKey = "identifier:SecurityPolicy";
        for (SecurityPolicy item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, SecurityPolicyDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SecurityPolicyDomain[] domain = new SecurityPolicyDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new SecurityPolicyDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItems().get(i).getName());
        }
        return domain;
    }

    public static String createCacheParentKey(String userName, String childType) {
        return String.join((CharSequence)":", "identifier", userName, childType);
    }

    public static String createCacheKey(String userName) {
        return String.join((CharSequence)":", userName);
    }

    public AttachSecurityPolicy model() {
        AttachSecurityPolicy value = this.cache.get(this.parentKey, AttachSecurityPolicyDomain.createCacheKey(this.getUserName() != null ? this.getUserName().toString() : null), AttachSecurityPolicy.class);
        return value;
    }
}

