/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.identifier.Gs2IdentifierRestClient;
import io.gs2.identifier.domain.model.PasswordDomain;
import io.gs2.identifier.domain.model.UserDomain;
import io.gs2.identifier.model.Password;
import io.gs2.identifier.request.DescribePasswordsRequest;
import io.gs2.identifier.result.DescribePasswordsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribePasswordsIterator
implements Iterator<Password>,
Iterable<Password> {
    CacheDatabase cache;
    Gs2IdentifierRestClient client;
    String userName;
    String pageToken;
    boolean last;
    List<Password> result;
    Integer fetchSize;

    public DescribePasswordsIterator(CacheDatabase cache, Gs2IdentifierRestClient client, String userName) {
        this.cache = cache;
        this.client = client;
        this.userName = userName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Password>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.userName != null ? this.userName.toString() : null, "Password");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Password.class)) {
            this.result = this.cache.list(parentKey, Password.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribePasswordsResult r = this.client.describePasswords(new DescribePasswordsRequest().withUserName(this.userName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Password item : this.result) {
                this.cache.put(parentKey, PasswordDomain.createCacheKey(item.getUserName() != null ? item.getUserName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Password.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Password next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Password ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Password> iterator() {
        return this;
    }
}

