/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier.domain;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.identifier.Gs2IdentifierRestClient;
import io.gs2.identifier.domain.iterator.DescribeCommonSecurityPoliciesIterator;
import io.gs2.identifier.domain.iterator.DescribeSecurityPoliciesIterator;
import io.gs2.identifier.domain.iterator.DescribeUsersIterator;
import io.gs2.identifier.domain.model.SecurityPolicyDomain;
import io.gs2.identifier.domain.model.UserDomain;
import io.gs2.identifier.request.CreateSecurityPolicyRequest;
import io.gs2.identifier.request.CreateUserRequest;
import io.gs2.identifier.result.CreateSecurityPolicyResult;
import io.gs2.identifier.result.CreateUserResult;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.model.JobResultBody;

public class Gs2Identifier {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2IdentifierRestClient client;
    private final String parentKey;

    public Gs2Identifier(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2IdentifierRestClient(session);
        this.parentKey = "identifier";
    }

    public UserDomain createUser(CreateUserRequest request) {
        CreateUserResult result = this.client.createUser(request);
        String parentKey = "identifier:User";
        if (result.getItem() != null) {
            this.cache.put(parentKey, UserDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        UserDomain domain = new UserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public SecurityPolicyDomain createSecurityPolicy(CreateSecurityPolicyRequest request) {
        CreateSecurityPolicyResult result = this.client.createSecurityPolicy(request);
        String parentKey = "identifier:SecurityPolicy";
        if (result.getItem() != null) {
            this.cache.put(parentKey, SecurityPolicyDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SecurityPolicyDomain domain = new SecurityPolicyDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public DescribeUsersIterator users() {
        return new DescribeUsersIterator(this.cache, this.client);
    }

    public UserDomain user(String userName) {
        return new UserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, userName);
    }

    public DescribeSecurityPoliciesIterator securityPolicies() {
        return new DescribeSecurityPoliciesIterator(this.cache, this.client);
    }

    public DescribeCommonSecurityPoliciesIterator commonSecurityPolicies() {
        return new DescribeCommonSecurityPoliciesIterator(this.cache, this.client);
    }

    public SecurityPolicyDomain securityPolicy(String securityPolicyName) {
        return new SecurityPolicyDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, securityPolicyName);
    }

    public static void updateCacheFromStampSheet(CacheDatabase cache, String method, String request, String result) {
    }

    public static void updateCacheFromStampTask(CacheDatabase cache, String method, String request, String result) {
    }

    public static void updateCacheFromJobResult(CacheDatabase cache, String method, Job job, JobResultBody result) {
    }
}

