/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.gateway.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2WebSocketSession;
import io.gs2.gateway.Gs2GatewayRestClient;
import io.gs2.gateway.Gs2GatewayWebSocketClient;
import io.gs2.gateway.domain.iterator.DescribeWebSocketSessionsByUserIdIterator;
import io.gs2.gateway.domain.model.FirebaseTokenDomain;
import io.gs2.gateway.domain.model.NamespaceDomain;
import io.gs2.gateway.domain.model.WebSocketSessionDomain;
import io.gs2.gateway.request.SendNotificationRequest;
import io.gs2.gateway.result.SendNotificationResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2GatewayRestClient client;
    private final Gs2WebSocketSession wssession;
    private final Gs2GatewayWebSocketClient wsclient;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String protocol;
    String nextPageToken;

    public String getProtocol() {
        return this.protocol;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, Gs2WebSocketSession wssession, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2GatewayRestClient(session);
        this.wssession = wssession;
        this.wsclient = new Gs2GatewayWebSocketClient(wssession);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public UserDomain sendNotification(SendNotificationRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        SendNotificationResult result = this.client.sendNotification(request);
        UserDomain domain = this;
        this.protocol = result.getProtocol();
        return domain;
    }

    public DescribeWebSocketSessionsByUserIdIterator webSocketSessions() {
        return new DescribeWebSocketSessionsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public WebSocketSessionDomain webSocketSession(String connectionId) {
        return new WebSocketSessionDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.wssession, this.namespaceName, this.userId, connectionId);
    }

    public FirebaseTokenDomain firebaseToken() {
        return new FirebaseTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.wssession, this.namespaceName, this.userId);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "gateway", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

