/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.gateway.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2WebSocketSession;
import io.gs2.gateway.Gs2GatewayRestClient;
import io.gs2.gateway.Gs2GatewayWebSocketClient;
import io.gs2.gateway.domain.model.UserDomain;
import io.gs2.gateway.model.FirebaseToken;
import io.gs2.gateway.request.DeleteFirebaseTokenByUserIdRequest;
import io.gs2.gateway.request.GetFirebaseTokenByUserIdRequest;
import io.gs2.gateway.request.SendMobileNotificationByUserIdRequest;
import io.gs2.gateway.request.SetFirebaseTokenByUserIdRequest;
import io.gs2.gateway.result.DeleteFirebaseTokenByUserIdResult;
import io.gs2.gateway.result.GetFirebaseTokenByUserIdResult;
import io.gs2.gateway.result.SendMobileNotificationByUserIdResult;
import io.gs2.gateway.result.SetFirebaseTokenByUserIdResult;

public class FirebaseTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2GatewayRestClient client;
    private final Gs2WebSocketSession wssession;
    private final Gs2GatewayWebSocketClient wsclient;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public FirebaseTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, Gs2WebSocketSession wssession, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2GatewayRestClient(session);
        this.wssession = wssession;
        this.wsclient = new Gs2GatewayWebSocketClient(wssession);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "FirebaseToken");
    }

    public FirebaseTokenDomain set(SetFirebaseTokenByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        SetFirebaseTokenByUserIdResult result = this.client.setFirebaseTokenByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FirebaseTokenDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FirebaseTokenDomain domain = this;
        return domain;
    }

    private FirebaseToken get(GetFirebaseTokenByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        GetFirebaseTokenByUserIdResult result = this.client.getFirebaseTokenByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FirebaseTokenDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FirebaseTokenDomain delete(DeleteFirebaseTokenByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        DeleteFirebaseTokenByUserIdResult result = null;
        try {
            result = this.client.deleteFirebaseTokenByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FirebaseTokenDomain.createCacheKey(), FirebaseToken.class);
        FirebaseTokenDomain domain = this;
        return domain;
    }

    public FirebaseTokenDomain sendMobileNotification(SendMobileNotificationByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        SendMobileNotificationByUserIdResult result = this.client.sendMobileNotificationByUserId(request);
        FirebaseTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "gateway", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public FirebaseToken model() {
        FirebaseToken value = this.cache.get(this.parentKey, FirebaseTokenDomain.createCacheKey(), FirebaseToken.class);
        if (value == null) {
            try {
                this.get(new GetFirebaseTokenByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, FirebaseTokenDomain.createCacheKey(), FirebaseToken.class);
            }
            value = this.cache.get(this.parentKey, FirebaseTokenDomain.createCacheKey(), FirebaseToken.class);
        }
        return value;
    }
}

