/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.gateway.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2WebSocketSession;
import io.gs2.gateway.Gs2GatewayRestClient;
import io.gs2.gateway.Gs2GatewayWebSocketClient;
import io.gs2.gateway.domain.model.FirebaseTokenDomain;
import io.gs2.gateway.domain.model.UserDomain;
import io.gs2.gateway.model.FirebaseToken;
import io.gs2.gateway.request.DeleteFirebaseTokenRequest;
import io.gs2.gateway.request.GetFirebaseTokenRequest;
import io.gs2.gateway.request.SetFirebaseTokenRequest;
import io.gs2.gateway.result.DeleteFirebaseTokenResult;
import io.gs2.gateway.result.GetFirebaseTokenResult;
import io.gs2.gateway.result.SetFirebaseTokenResult;

public class FirebaseTokenAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2GatewayRestClient client;
    private final Gs2WebSocketSession wssession;
    private final Gs2GatewayWebSocketClient wsclient;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public FirebaseTokenAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, Gs2WebSocketSession wssession, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2GatewayRestClient(session);
        this.wssession = wssession;
        this.wsclient = new Gs2GatewayWebSocketClient(wssession);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "FirebaseToken");
    }

    public FirebaseTokenAccessTokenDomain set(SetFirebaseTokenRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        SetFirebaseTokenResult result = this.client.setFirebaseToken(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FirebaseTokenDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FirebaseTokenAccessTokenDomain domain = this;
        return domain;
    }

    private FirebaseToken get(GetFirebaseTokenRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        GetFirebaseTokenResult result = this.client.getFirebaseToken(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FirebaseTokenDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FirebaseTokenAccessTokenDomain delete(DeleteFirebaseTokenRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        DeleteFirebaseTokenResult result = null;
        try {
            result = this.client.deleteFirebaseToken(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FirebaseTokenDomain.createCacheKey(), FirebaseToken.class);
        FirebaseTokenAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "gateway", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public FirebaseToken model() {
        FirebaseToken value = this.cache.get(this.parentKey, FirebaseTokenDomain.createCacheKey(), FirebaseToken.class);
        if (value == null) {
            try {
                this.get(new GetFirebaseTokenRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, FirebaseTokenDomain.createCacheKey(), FirebaseToken.class);
            }
            value = this.cache.get(this.parentKey, FirebaseTokenDomain.createCacheKey(), FirebaseToken.class);
        }
        return value;
    }
}

