/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.gateway.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.gateway.Gs2GatewayRestClient;
import io.gs2.gateway.domain.model.UserDomain;
import io.gs2.gateway.domain.model.WebSocketSessionDomain;
import io.gs2.gateway.model.WebSocketSession;
import io.gs2.gateway.request.DescribeWebSocketSessionsByUserIdRequest;
import io.gs2.gateway.result.DescribeWebSocketSessionsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeWebSocketSessionsByUserIdIterator
implements Iterator<WebSocketSession>,
Iterable<WebSocketSession> {
    CacheDatabase cache;
    Gs2GatewayRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<WebSocketSession> result;
    Integer fetchSize;

    public DescribeWebSocketSessionsByUserIdIterator(CacheDatabase cache, Gs2GatewayRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<WebSocketSession>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "WebSocketSession");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, WebSocketSession.class)) {
            this.result = this.cache.list(parentKey, WebSocketSession.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeWebSocketSessionsByUserIdResult r = this.client.describeWebSocketSessionsByUserId(new DescribeWebSocketSessionsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (WebSocketSession item : this.result) {
                this.cache.put(parentKey, WebSocketSessionDomain.createCacheKey(), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, WebSocketSession.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public WebSocketSession next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        WebSocketSession ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<WebSocketSession> iterator() {
        return this;
    }
}

