/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FriendRequestDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.FriendRequest;
import io.gs2.friend.model.SendFriendRequest;
import io.gs2.friend.request.DeleteRequestByUserIdRequest;
import io.gs2.friend.request.GetSendRequestByUserIdRequest;
import io.gs2.friend.result.DeleteRequestByUserIdResult;
import io.gs2.friend.result.GetSendRequestByUserIdResult;

public class SendFriendRequestDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String targetUserId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public SendFriendRequestDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String targetUserId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.targetUserId = targetUserId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "SendFriendRequest");
    }

    private FriendRequest get(GetSendRequestByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withTargetUserId(this.targetUserId);
        GetSendRequestByUserIdResult result = this.client.getSendRequestByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FriendRequestDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FriendRequestDomain delete(DeleteRequestByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withTargetUserId(this.targetUserId);
        DeleteRequestByUserIdResult result = null;
        try {
            result = this.client.deleteRequestByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FriendRequestDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), FriendRequest.class);
        FriendRequestDomain domain = new FriendRequestDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getTargetUserId());
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String targetUserId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, targetUserId, childType);
    }

    public static String createCacheKey(String targetUserId) {
        return String.join((CharSequence)":", targetUserId);
    }

    public FriendRequest model() {
        FriendRequest value = this.cache.get(this.parentKey, SendFriendRequestDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendRequest.class);
        if (value == null) {
            try {
                this.get(new GetSendRequestByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, SendFriendRequestDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), SendFriendRequest.class);
            }
            value = this.cache.get(this.parentKey, SendFriendRequestDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendRequest.class);
        }
        return value;
    }
}

