/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FriendRequestDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.FriendRequest;
import io.gs2.friend.model.ReceiveFriendRequest;
import io.gs2.friend.request.AcceptRequestByUserIdRequest;
import io.gs2.friend.request.GetReceiveRequestByUserIdRequest;
import io.gs2.friend.request.RejectRequestByUserIdRequest;
import io.gs2.friend.result.AcceptRequestByUserIdResult;
import io.gs2.friend.result.GetReceiveRequestByUserIdResult;
import io.gs2.friend.result.RejectRequestByUserIdResult;

public class ReceiveFriendRequestDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String fromUserId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFromUserId() {
        return this.fromUserId;
    }

    public ReceiveFriendRequestDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String fromUserId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.fromUserId = fromUserId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "ReceiveFriendRequest");
    }

    private FriendRequest get(GetReceiveRequestByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withFromUserId(this.fromUserId);
        GetReceiveRequestByUserIdResult result = this.client.getReceiveRequestByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FriendRequestDomain.createCacheKey(result.getItem().getTargetUserId() != null ? result.getItem().getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FriendRequestDomain accept(AcceptRequestByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withFromUserId(this.fromUserId);
        AcceptRequestByUserIdResult result = null;
        try {
            result = this.client.acceptRequestByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FriendRequestDomain.createCacheKey(result.getItem().getTargetUserId() != null ? result.getItem().getTargetUserId().toString() : null), FriendRequest.class);
        this.cache.listCacheClear(UserDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.fromUserId != null ? this.fromUserId.toString() : null, "SendFriendRequest"), FriendRequest.class);
        this.cache.listCacheClear(UserDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.getUserId() != null ? this.getUserId().toString() : null, "ReceiveFriendRequest"), FriendRequest.class);
        FriendRequestDomain domain = new FriendRequestDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), this.fromUserId);
        return domain;
    }

    public FriendRequestDomain reject(RejectRequestByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withFromUserId(this.fromUserId);
        RejectRequestByUserIdResult result = null;
        try {
            result = this.client.rejectRequestByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FriendRequestDomain.createCacheKey(result.getItem().getTargetUserId() != null ? result.getItem().getTargetUserId().toString() : null), FriendRequest.class);
        this.cache.listCacheClear(UserDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.fromUserId != null ? this.fromUserId.toString() : null, "SendFriendRequest"), FriendRequest.class);
        this.cache.listCacheClear(UserDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.getUserId() != null ? this.getUserId().toString() : null, "ReceiveFriendRequest"), FriendRequest.class);
        FriendRequestDomain domain = new FriendRequestDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), this.fromUserId);
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String fromUserId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, fromUserId, childType);
    }

    public static String createCacheKey(String fromUserId) {
        return String.join((CharSequence)":", fromUserId);
    }

    public FriendRequest model() {
        FriendRequest value = this.cache.get(this.parentKey, ReceiveFriendRequestDomain.createCacheKey(this.getFromUserId() != null ? this.getFromUserId().toString() : null), FriendRequest.class);
        if (value == null) {
            try {
                this.get(new GetReceiveRequestByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ReceiveFriendRequestDomain.createCacheKey(this.getFromUserId() != null ? this.getFromUserId().toString() : null), ReceiveFriendRequest.class);
            }
            value = this.cache.get(this.parentKey, ReceiveFriendRequestDomain.createCacheKey(this.getFromUserId() != null ? this.getFromUserId().toString() : null), FriendRequest.class);
        }
        return value;
    }
}

