/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FriendRequestAccessTokenDomain;
import io.gs2.friend.domain.model.FriendRequestDomain;
import io.gs2.friend.domain.model.ReceiveFriendRequestDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.FriendRequest;
import io.gs2.friend.model.ReceiveFriendRequest;
import io.gs2.friend.request.AcceptRequestRequest;
import io.gs2.friend.request.GetReceiveRequestRequest;
import io.gs2.friend.request.RejectRequestRequest;
import io.gs2.friend.result.AcceptRequestResult;
import io.gs2.friend.result.GetReceiveRequestResult;
import io.gs2.friend.result.RejectRequestResult;

public class ReceiveFriendRequestAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String fromUserId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getFromUserId() {
        return this.fromUserId;
    }

    public ReceiveFriendRequestAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String fromUserId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.fromUserId = fromUserId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "ReceiveFriendRequest");
    }

    private FriendRequest get(GetReceiveRequestRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withFromUserId(this.fromUserId);
        GetReceiveRequestResult result = this.client.getReceiveRequest(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FriendRequestDomain.createCacheKey(result.getItem().getTargetUserId() != null ? result.getItem().getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FriendRequestAccessTokenDomain accept(AcceptRequestRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withFromUserId(this.fromUserId);
        AcceptRequestResult result = null;
        try {
            result = this.client.acceptRequest(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FriendRequestDomain.createCacheKey(result.getItem().getTargetUserId() != null ? result.getItem().getTargetUserId().toString() : null), FriendRequest.class);
        this.cache.listCacheClear(UserDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.fromUserId != null ? this.fromUserId.toString() : null, "SendFriendRequest"), FriendRequest.class);
        this.cache.listCacheClear(UserDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.getUserId() != null ? this.getUserId().toString() : null, "ReceiveFriendRequest"), FriendRequest.class);
        FriendRequestAccessTokenDomain domain = new FriendRequestAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, this.fromUserId);
        return domain;
    }

    public FriendRequestAccessTokenDomain reject(RejectRequestRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withFromUserId(this.fromUserId);
        RejectRequestResult result = null;
        try {
            result = this.client.rejectRequest(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FriendRequestDomain.createCacheKey(result.getItem().getTargetUserId() != null ? result.getItem().getTargetUserId().toString() : null), FriendRequest.class);
        this.cache.listCacheClear(UserDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.fromUserId != null ? this.fromUserId.toString() : null, "SendFriendRequest"), FriendRequest.class);
        this.cache.listCacheClear(UserDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.getUserId() != null ? this.getUserId().toString() : null, "ReceiveFriendRequest"), FriendRequest.class);
        FriendRequestAccessTokenDomain domain = new FriendRequestAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, this.fromUserId);
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String fromUserId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, fromUserId, childType);
    }

    public static String createCacheKey(String fromUserId) {
        return String.join((CharSequence)":", fromUserId);
    }

    public FriendRequest model() {
        FriendRequest value = this.cache.get(this.parentKey, ReceiveFriendRequestDomain.createCacheKey(this.getFromUserId() != null ? this.getFromUserId().toString() : null), FriendRequest.class);
        if (value == null) {
            try {
                this.get(new GetReceiveRequestRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ReceiveFriendRequestDomain.createCacheKey(this.getFromUserId() != null ? this.getFromUserId().toString() : null), ReceiveFriendRequest.class);
            }
            value = this.cache.get(this.parentKey, ReceiveFriendRequestDomain.createCacheKey(this.getFromUserId() != null ? this.getFromUserId().toString() : null), FriendRequest.class);
        }
        return value;
    }
}

