/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.PublicProfileDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.Profile;
import io.gs2.friend.request.DeleteProfileByUserIdRequest;
import io.gs2.friend.request.GetProfileByUserIdRequest;
import io.gs2.friend.request.GetPublicProfileRequest;
import io.gs2.friend.request.UpdateProfileByUserIdRequest;
import io.gs2.friend.result.DeleteProfileByUserIdResult;
import io.gs2.friend.result.GetProfileByUserIdResult;
import io.gs2.friend.result.GetPublicProfileResult;
import io.gs2.friend.result.UpdateProfileByUserIdResult;

public class ProfileDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public ProfileDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Profile");
    }

    private Profile get(GetProfileByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        GetProfileByUserIdResult result = this.client.getProfileByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProfileDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ProfileDomain update(UpdateProfileByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        UpdateProfileByUserIdResult result = this.client.updateProfileByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProfileDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ProfileDomain domain = this;
        return domain;
    }

    public ProfileDomain delete(DeleteProfileByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        DeleteProfileByUserIdResult result = null;
        try {
            result = this.client.deleteProfileByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        ProfileDomain domain = this;
        return domain;
    }

    public PublicProfileDomain getPublic(GetPublicProfileRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        GetPublicProfileResult result = this.client.getPublicProfile(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "PublicProfile");
        if (result.getItem() != null) {
            this.cache.put(parentKey, PublicProfileDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        PublicProfileDomain domain = new PublicProfileDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId());
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public Profile model() {
        Profile value = this.cache.get(this.parentKey, ProfileDomain.createCacheKey(), Profile.class);
        if (value == null) {
            try {
                this.get(new GetProfileByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ProfileDomain.createCacheKey(), Profile.class);
            }
            value = this.cache.get(this.parentKey, ProfileDomain.createCacheKey(), Profile.class);
        }
        return value;
    }
}

