/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FriendDomain;
import io.gs2.friend.model.FriendUser;
import io.gs2.friend.request.DeleteFriendByUserIdRequest;
import io.gs2.friend.request.GetFriendByUserIdRequest;
import io.gs2.friend.result.DeleteFriendByUserIdResult;
import io.gs2.friend.result.GetFriendByUserIdResult;

public class FriendUserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final String userId;
    private final Boolean withProfile;
    private final String targetUserId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getWithProfile() {
        return this.withProfile;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public FriendUserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, Boolean withProfile, String targetUserId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.withProfile = withProfile;
        this.targetUserId = targetUserId;
        this.parentKey = FriendDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.withProfile != null ? this.withProfile.toString() : "false", "FriendUser");
    }

    private FriendUser get(GetFriendByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withWithProfile(this.withProfile).withTargetUserId(this.targetUserId);
        GetFriendByUserIdResult result = this.client.getFriendByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FriendUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FriendUserDomain delete(DeleteFriendByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withTargetUserId(this.targetUserId);
        DeleteFriendByUserIdResult result = null;
        try {
            result = this.client.deleteFriendByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FriendUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), FriendUser.class);
        this.cache.delete(FriendDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.getTargetUserId() != null ? this.getTargetUserId().toString() : null, this.withProfile != null ? this.withProfile.toString() : "false", "FriendUser"), FriendUserDomain.createCacheKey(this.getUserId() != null ? this.getUserId().toString() : null), FriendUser.class);
        FriendUserDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String withProfile, String targetUserId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, withProfile, targetUserId, childType);
    }

    public static String createCacheKey(String targetUserId) {
        return String.join((CharSequence)":", targetUserId);
    }

    public FriendUser model() {
        FriendUser value = this.cache.get(this.parentKey, FriendUserDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendUser.class);
        if (value == null) {
            try {
                this.get(new GetFriendByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, FriendUserDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendUser.class);
            }
            value = this.cache.get(this.parentKey, FriendUserDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FriendUser.class);
        }
        return value;
    }
}

