/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FollowDomain;
import io.gs2.friend.domain.model.FollowUserDomain;
import io.gs2.friend.model.FollowUser;
import io.gs2.friend.request.GetFollowRequest;
import io.gs2.friend.request.UnfollowRequest;
import io.gs2.friend.result.GetFollowResult;
import io.gs2.friend.result.UnfollowResult;

public class FollowUserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final Boolean withProfile;
    private final String targetUserId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public Boolean getWithProfile() {
        return this.withProfile;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public FollowUserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, Boolean withProfile, String targetUserId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.withProfile = withProfile;
        this.targetUserId = targetUserId;
        this.parentKey = FollowDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, this.withProfile != null ? this.withProfile.toString() : "false", "FollowUser");
    }

    private FollowUser get(GetFollowRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withWithProfile(this.withProfile).withTargetUserId(this.targetUserId);
        GetFollowResult result = this.client.getFollow(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FollowUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FollowUserAccessTokenDomain unfollow(UnfollowRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withTargetUserId(this.targetUserId);
        UnfollowResult result = null;
        try {
            result = this.client.unfollow(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FollowUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), FollowUser.class);
        String parentKey = FollowDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "false", "FollowUser");
        this.cache.delete(parentKey, FollowUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), FollowUser.class);
        parentKey = FollowDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "true", "FollowUser");
        this.cache.delete(parentKey, FollowUserDomain.createCacheKey(request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), FollowUser.class);
        FollowUserAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String withProfile, String targetUserId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, withProfile, targetUserId, childType);
    }

    public static String createCacheKey(String targetUserId) {
        return String.join((CharSequence)":", targetUserId);
    }

    public FollowUser model() {
        FollowUser value = this.cache.get(this.parentKey, FollowUserDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FollowUser.class);
        if (value == null) {
            try {
                this.get(new GetFollowRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, FollowUserDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FollowUser.class);
            }
            value = this.cache.get(this.parentKey, FollowUserDomain.createCacheKey(this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), FollowUser.class);
        }
        return value;
    }
}

