/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.BlackList;
import io.gs2.friend.request.RegisterBlackListByUserIdRequest;
import io.gs2.friend.request.UnregisterBlackListByUserIdRequest;
import io.gs2.friend.result.RegisterBlackListByUserIdResult;
import io.gs2.friend.result.UnregisterBlackListByUserIdResult;

public class BlackListDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public BlackListDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "BlackList");
    }

    public BlackListDomain register(RegisterBlackListByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        RegisterBlackListByUserIdResult result = this.client.registerBlackListByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, BlackListDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        BlackListDomain domain = this;
        return domain;
    }

    public BlackListDomain unregister(UnregisterBlackListByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        UnregisterBlackListByUserIdResult result = this.client.unregisterBlackListByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, BlackListDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        BlackListDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public BlackList model() {
        BlackList value = this.cache.get(this.parentKey, BlackListDomain.createCacheKey(), BlackList.class);
        return value;
    }
}

