/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.BlackListDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.BlackList;
import io.gs2.friend.request.RegisterBlackListRequest;
import io.gs2.friend.request.UnregisterBlackListRequest;
import io.gs2.friend.result.RegisterBlackListResult;
import io.gs2.friend.result.UnregisterBlackListResult;

public class BlackListAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FriendRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public BlackListAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FriendRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "BlackList");
    }

    public BlackListAccessTokenDomain register(RegisterBlackListRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        RegisterBlackListResult result = this.client.registerBlackList(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, BlackListDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        BlackListAccessTokenDomain domain = this;
        return domain;
    }

    public BlackListAccessTokenDomain unregister(UnregisterBlackListRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        UnregisterBlackListResult result = this.client.unregisterBlackList(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, BlackListDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        BlackListAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "friend", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public BlackList model() {
        BlackList value = this.cache.get(this.parentKey, BlackListDomain.createCacheKey(), BlackList.class);
        return value;
    }
}

