/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.ReceiveFriendRequestDomain;
import io.gs2.friend.domain.model.UserDomain;
import io.gs2.friend.model.FriendRequest;
import io.gs2.friend.request.DescribeReceiveRequestsByUserIdRequest;
import io.gs2.friend.result.DescribeReceiveRequestsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeReceiveRequestsByUserIdIterator
implements Iterator<FriendRequest>,
Iterable<FriendRequest> {
    CacheDatabase cache;
    Gs2FriendRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<FriendRequest> result;
    Integer fetchSize;

    public DescribeReceiveRequestsByUserIdIterator(CacheDatabase cache, Gs2FriendRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<FriendRequest>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "ReceiveFriendRequest");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, FriendRequest.class)) {
            this.result = this.cache.list(parentKey, FriendRequest.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeReceiveRequestsByUserIdResult r = this.client.describeReceiveRequestsByUserId(new DescribeReceiveRequestsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (FriendRequest item : this.result) {
                this.cache.put(parentKey, ReceiveFriendRequestDomain.createCacheKey(item.getUserId() != null ? item.getUserId().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, FriendRequest.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public FriendRequest next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        FriendRequest ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<FriendRequest> iterator() {
        return this;
    }
}

