/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.friend.Gs2FriendRestClient;
import io.gs2.friend.domain.model.FollowDomain;
import io.gs2.friend.domain.model.FollowUserDomain;
import io.gs2.friend.model.FollowUser;
import io.gs2.friend.request.DescribeFollowsByUserIdRequest;
import io.gs2.friend.result.DescribeFollowsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeFollowsByUserIdIterator
implements Iterator<FollowUser>,
Iterable<FollowUser> {
    CacheDatabase cache;
    Gs2FriendRestClient client;
    String namespaceName;
    String userId;
    Boolean withProfile;
    String pageToken;
    boolean last;
    List<FollowUser> result;
    Integer fetchSize;

    public DescribeFollowsByUserIdIterator(CacheDatabase cache, Gs2FriendRestClient client, String namespaceName, String userId, Boolean withProfile) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.withProfile = withProfile;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<FollowUser>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = FollowDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.withProfile != null ? this.withProfile.toString() : "false", "FollowUser");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, FollowUser.class)) {
            this.result = this.cache.list(parentKey, FollowUser.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeFollowsByUserIdResult r = this.client.describeFollowsByUserId(new DescribeFollowsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withWithProfile(this.withProfile).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (FollowUser item : this.result) {
                this.cache.put(parentKey, FollowUserDomain.createCacheKey(item.getUserId() != null ? item.getUserId().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, FollowUser.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public FollowUser next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        FollowUser ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<FollowUser> iterator() {
        return this;
    }
}

