/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.friend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.friend.request.AcceptRequestByUserIdRequest;
import io.gs2.friend.request.AcceptRequestRequest;
import io.gs2.friend.request.CreateNamespaceRequest;
import io.gs2.friend.request.DeleteFriendByUserIdRequest;
import io.gs2.friend.request.DeleteFriendRequest;
import io.gs2.friend.request.DeleteNamespaceRequest;
import io.gs2.friend.request.DeleteProfileByUserIdRequest;
import io.gs2.friend.request.DeleteRequestByUserIdRequest;
import io.gs2.friend.request.DeleteRequestRequest;
import io.gs2.friend.request.DescribeBlackListByUserIdRequest;
import io.gs2.friend.request.DescribeBlackListRequest;
import io.gs2.friend.request.DescribeFollowsByUserIdRequest;
import io.gs2.friend.request.DescribeFollowsRequest;
import io.gs2.friend.request.DescribeFriendsByUserIdRequest;
import io.gs2.friend.request.DescribeFriendsRequest;
import io.gs2.friend.request.DescribeNamespacesRequest;
import io.gs2.friend.request.DescribeReceiveRequestsByUserIdRequest;
import io.gs2.friend.request.DescribeReceiveRequestsRequest;
import io.gs2.friend.request.DescribeSendRequestsByUserIdRequest;
import io.gs2.friend.request.DescribeSendRequestsRequest;
import io.gs2.friend.request.FollowByUserIdRequest;
import io.gs2.friend.request.FollowRequest;
import io.gs2.friend.request.GetFollowByUserIdRequest;
import io.gs2.friend.request.GetFollowRequest;
import io.gs2.friend.request.GetFriendByUserIdRequest;
import io.gs2.friend.request.GetFriendRequest;
import io.gs2.friend.request.GetNamespaceRequest;
import io.gs2.friend.request.GetNamespaceStatusRequest;
import io.gs2.friend.request.GetProfileByUserIdRequest;
import io.gs2.friend.request.GetProfileRequest;
import io.gs2.friend.request.GetPublicProfileRequest;
import io.gs2.friend.request.GetReceiveRequestByUserIdRequest;
import io.gs2.friend.request.GetReceiveRequestRequest;
import io.gs2.friend.request.GetSendRequestByUserIdRequest;
import io.gs2.friend.request.GetSendRequestRequest;
import io.gs2.friend.request.RegisterBlackListByUserIdRequest;
import io.gs2.friend.request.RegisterBlackListRequest;
import io.gs2.friend.request.RejectRequestByUserIdRequest;
import io.gs2.friend.request.RejectRequestRequest;
import io.gs2.friend.request.SendRequestByUserIdRequest;
import io.gs2.friend.request.SendRequestRequest;
import io.gs2.friend.request.UnfollowByUserIdRequest;
import io.gs2.friend.request.UnfollowRequest;
import io.gs2.friend.request.UnregisterBlackListByUserIdRequest;
import io.gs2.friend.request.UnregisterBlackListRequest;
import io.gs2.friend.request.UpdateNamespaceRequest;
import io.gs2.friend.request.UpdateProfileByUserIdRequest;
import io.gs2.friend.request.UpdateProfileRequest;
import io.gs2.friend.result.AcceptRequestByUserIdResult;
import io.gs2.friend.result.AcceptRequestResult;
import io.gs2.friend.result.CreateNamespaceResult;
import io.gs2.friend.result.DeleteFriendByUserIdResult;
import io.gs2.friend.result.DeleteFriendResult;
import io.gs2.friend.result.DeleteNamespaceResult;
import io.gs2.friend.result.DeleteProfileByUserIdResult;
import io.gs2.friend.result.DeleteRequestByUserIdResult;
import io.gs2.friend.result.DeleteRequestResult;
import io.gs2.friend.result.DescribeBlackListByUserIdResult;
import io.gs2.friend.result.DescribeBlackListResult;
import io.gs2.friend.result.DescribeFollowsByUserIdResult;
import io.gs2.friend.result.DescribeFollowsResult;
import io.gs2.friend.result.DescribeFriendsByUserIdResult;
import io.gs2.friend.result.DescribeFriendsResult;
import io.gs2.friend.result.DescribeNamespacesResult;
import io.gs2.friend.result.DescribeReceiveRequestsByUserIdResult;
import io.gs2.friend.result.DescribeReceiveRequestsResult;
import io.gs2.friend.result.DescribeSendRequestsByUserIdResult;
import io.gs2.friend.result.DescribeSendRequestsResult;
import io.gs2.friend.result.FollowByUserIdResult;
import io.gs2.friend.result.FollowResult;
import io.gs2.friend.result.GetFollowByUserIdResult;
import io.gs2.friend.result.GetFollowResult;
import io.gs2.friend.result.GetFriendByUserIdResult;
import io.gs2.friend.result.GetFriendResult;
import io.gs2.friend.result.GetNamespaceResult;
import io.gs2.friend.result.GetNamespaceStatusResult;
import io.gs2.friend.result.GetProfileByUserIdResult;
import io.gs2.friend.result.GetProfileResult;
import io.gs2.friend.result.GetPublicProfileResult;
import io.gs2.friend.result.GetReceiveRequestByUserIdResult;
import io.gs2.friend.result.GetReceiveRequestResult;
import io.gs2.friend.result.GetSendRequestByUserIdResult;
import io.gs2.friend.result.GetSendRequestResult;
import io.gs2.friend.result.RegisterBlackListByUserIdResult;
import io.gs2.friend.result.RegisterBlackListResult;
import io.gs2.friend.result.RejectRequestByUserIdResult;
import io.gs2.friend.result.RejectRequestResult;
import io.gs2.friend.result.SendRequestByUserIdResult;
import io.gs2.friend.result.SendRequestResult;
import io.gs2.friend.result.UnfollowByUserIdResult;
import io.gs2.friend.result.UnfollowResult;
import io.gs2.friend.result.UnregisterBlackListByUserIdResult;
import io.gs2.friend.result.UnregisterBlackListResult;
import io.gs2.friend.result.UpdateNamespaceResult;
import io.gs2.friend.result.UpdateProfileByUserIdResult;
import io.gs2.friend.result.UpdateProfileResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2FriendRestClient
extends AbstractGs2Client<Gs2FriendRestClient> {
    public Gs2FriendRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getProfileAsync(GetProfileRequest request, AsyncAction<AsyncResult<GetProfileResult>> callback) {
        GetProfileTask task = new GetProfileTask(request, callback);
        this.session.execute(task);
    }

    public GetProfileResult getProfile(GetProfileRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getProfileAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetProfileResult)resultAsyncResult[0].getResult();
    }

    public void getProfileByUserIdAsync(GetProfileByUserIdRequest request, AsyncAction<AsyncResult<GetProfileByUserIdResult>> callback) {
        GetProfileByUserIdTask task = new GetProfileByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetProfileByUserIdResult getProfileByUserId(GetProfileByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getProfileByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetProfileByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void updateProfileAsync(UpdateProfileRequest request, AsyncAction<AsyncResult<UpdateProfileResult>> callback) {
        UpdateProfileTask task = new UpdateProfileTask(request, callback);
        this.session.execute(task);
    }

    public UpdateProfileResult updateProfile(UpdateProfileRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateProfileAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateProfileResult)resultAsyncResult[0].getResult();
    }

    public void updateProfileByUserIdAsync(UpdateProfileByUserIdRequest request, AsyncAction<AsyncResult<UpdateProfileByUserIdResult>> callback) {
        UpdateProfileByUserIdTask task = new UpdateProfileByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UpdateProfileByUserIdResult updateProfileByUserId(UpdateProfileByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateProfileByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateProfileByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteProfileByUserIdAsync(DeleteProfileByUserIdRequest request, AsyncAction<AsyncResult<DeleteProfileByUserIdResult>> callback) {
        DeleteProfileByUserIdTask task = new DeleteProfileByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteProfileByUserIdResult deleteProfileByUserId(DeleteProfileByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteProfileByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteProfileByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeFriendsAsync(DescribeFriendsRequest request, AsyncAction<AsyncResult<DescribeFriendsResult>> callback) {
        DescribeFriendsTask task = new DescribeFriendsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeFriendsResult describeFriends(DescribeFriendsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeFriendsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeFriendsResult)resultAsyncResult[0].getResult();
    }

    public void describeFriendsByUserIdAsync(DescribeFriendsByUserIdRequest request, AsyncAction<AsyncResult<DescribeFriendsByUserIdResult>> callback) {
        DescribeFriendsByUserIdTask task = new DescribeFriendsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeFriendsByUserIdResult describeFriendsByUserId(DescribeFriendsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeFriendsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeFriendsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeBlackListAsync(DescribeBlackListRequest request, AsyncAction<AsyncResult<DescribeBlackListResult>> callback) {
        DescribeBlackListTask task = new DescribeBlackListTask(request, callback);
        this.session.execute(task);
    }

    public DescribeBlackListResult describeBlackList(DescribeBlackListRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeBlackListAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeBlackListResult)resultAsyncResult[0].getResult();
    }

    public void describeBlackListByUserIdAsync(DescribeBlackListByUserIdRequest request, AsyncAction<AsyncResult<DescribeBlackListByUserIdResult>> callback) {
        DescribeBlackListByUserIdTask task = new DescribeBlackListByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeBlackListByUserIdResult describeBlackListByUserId(DescribeBlackListByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeBlackListByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeBlackListByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void registerBlackListAsync(RegisterBlackListRequest request, AsyncAction<AsyncResult<RegisterBlackListResult>> callback) {
        RegisterBlackListTask task = new RegisterBlackListTask(request, callback);
        this.session.execute(task);
    }

    public RegisterBlackListResult registerBlackList(RegisterBlackListRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.registerBlackListAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RegisterBlackListResult)resultAsyncResult[0].getResult();
    }

    public void registerBlackListByUserIdAsync(RegisterBlackListByUserIdRequest request, AsyncAction<AsyncResult<RegisterBlackListByUserIdResult>> callback) {
        RegisterBlackListByUserIdTask task = new RegisterBlackListByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public RegisterBlackListByUserIdResult registerBlackListByUserId(RegisterBlackListByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.registerBlackListByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RegisterBlackListByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void unregisterBlackListAsync(UnregisterBlackListRequest request, AsyncAction<AsyncResult<UnregisterBlackListResult>> callback) {
        UnregisterBlackListTask task = new UnregisterBlackListTask(request, callback);
        this.session.execute(task);
    }

    public UnregisterBlackListResult unregisterBlackList(UnregisterBlackListRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unregisterBlackListAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnregisterBlackListResult)resultAsyncResult[0].getResult();
    }

    public void unregisterBlackListByUserIdAsync(UnregisterBlackListByUserIdRequest request, AsyncAction<AsyncResult<UnregisterBlackListByUserIdResult>> callback) {
        UnregisterBlackListByUserIdTask task = new UnregisterBlackListByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UnregisterBlackListByUserIdResult unregisterBlackListByUserId(UnregisterBlackListByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unregisterBlackListByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnregisterBlackListByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeFollowsAsync(DescribeFollowsRequest request, AsyncAction<AsyncResult<DescribeFollowsResult>> callback) {
        DescribeFollowsTask task = new DescribeFollowsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeFollowsResult describeFollows(DescribeFollowsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeFollowsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeFollowsResult)resultAsyncResult[0].getResult();
    }

    public void describeFollowsByUserIdAsync(DescribeFollowsByUserIdRequest request, AsyncAction<AsyncResult<DescribeFollowsByUserIdResult>> callback) {
        DescribeFollowsByUserIdTask task = new DescribeFollowsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeFollowsByUserIdResult describeFollowsByUserId(DescribeFollowsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeFollowsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeFollowsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getFollowAsync(GetFollowRequest request, AsyncAction<AsyncResult<GetFollowResult>> callback) {
        GetFollowTask task = new GetFollowTask(request, callback);
        this.session.execute(task);
    }

    public GetFollowResult getFollow(GetFollowRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getFollowAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetFollowResult)resultAsyncResult[0].getResult();
    }

    public void getFollowByUserIdAsync(GetFollowByUserIdRequest request, AsyncAction<AsyncResult<GetFollowByUserIdResult>> callback) {
        GetFollowByUserIdTask task = new GetFollowByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetFollowByUserIdResult getFollowByUserId(GetFollowByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getFollowByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetFollowByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void followAsync(FollowRequest request, AsyncAction<AsyncResult<FollowResult>> callback) {
        FollowTask task = new FollowTask(request, callback);
        this.session.execute(task);
    }

    public FollowResult follow(FollowRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.followAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (FollowResult)resultAsyncResult[0].getResult();
    }

    public void followByUserIdAsync(FollowByUserIdRequest request, AsyncAction<AsyncResult<FollowByUserIdResult>> callback) {
        FollowByUserIdTask task = new FollowByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public FollowByUserIdResult followByUserId(FollowByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.followByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (FollowByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void unfollowAsync(UnfollowRequest request, AsyncAction<AsyncResult<UnfollowResult>> callback) {
        UnfollowTask task = new UnfollowTask(request, callback);
        this.session.execute(task);
    }

    public UnfollowResult unfollow(UnfollowRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unfollowAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnfollowResult)resultAsyncResult[0].getResult();
    }

    public void unfollowByUserIdAsync(UnfollowByUserIdRequest request, AsyncAction<AsyncResult<UnfollowByUserIdResult>> callback) {
        UnfollowByUserIdTask task = new UnfollowByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UnfollowByUserIdResult unfollowByUserId(UnfollowByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unfollowByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnfollowByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getFriendAsync(GetFriendRequest request, AsyncAction<AsyncResult<GetFriendResult>> callback) {
        GetFriendTask task = new GetFriendTask(request, callback);
        this.session.execute(task);
    }

    public GetFriendResult getFriend(GetFriendRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getFriendAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetFriendResult)resultAsyncResult[0].getResult();
    }

    public void getFriendByUserIdAsync(GetFriendByUserIdRequest request, AsyncAction<AsyncResult<GetFriendByUserIdResult>> callback) {
        GetFriendByUserIdTask task = new GetFriendByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetFriendByUserIdResult getFriendByUserId(GetFriendByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getFriendByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetFriendByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteFriendAsync(DeleteFriendRequest request, AsyncAction<AsyncResult<DeleteFriendResult>> callback) {
        DeleteFriendTask task = new DeleteFriendTask(request, callback);
        this.session.execute(task);
    }

    public DeleteFriendResult deleteFriend(DeleteFriendRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteFriendAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteFriendResult)resultAsyncResult[0].getResult();
    }

    public void deleteFriendByUserIdAsync(DeleteFriendByUserIdRequest request, AsyncAction<AsyncResult<DeleteFriendByUserIdResult>> callback) {
        DeleteFriendByUserIdTask task = new DeleteFriendByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteFriendByUserIdResult deleteFriendByUserId(DeleteFriendByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteFriendByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteFriendByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeSendRequestsAsync(DescribeSendRequestsRequest request, AsyncAction<AsyncResult<DescribeSendRequestsResult>> callback) {
        DescribeSendRequestsTask task = new DescribeSendRequestsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSendRequestsResult describeSendRequests(DescribeSendRequestsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSendRequestsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSendRequestsResult)resultAsyncResult[0].getResult();
    }

    public void describeSendRequestsByUserIdAsync(DescribeSendRequestsByUserIdRequest request, AsyncAction<AsyncResult<DescribeSendRequestsByUserIdResult>> callback) {
        DescribeSendRequestsByUserIdTask task = new DescribeSendRequestsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSendRequestsByUserIdResult describeSendRequestsByUserId(DescribeSendRequestsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSendRequestsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSendRequestsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getSendRequestAsync(GetSendRequestRequest request, AsyncAction<AsyncResult<GetSendRequestResult>> callback) {
        GetSendRequestTask task = new GetSendRequestTask(request, callback);
        this.session.execute(task);
    }

    public GetSendRequestResult getSendRequest(GetSendRequestRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSendRequestAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSendRequestResult)resultAsyncResult[0].getResult();
    }

    public void getSendRequestByUserIdAsync(GetSendRequestByUserIdRequest request, AsyncAction<AsyncResult<GetSendRequestByUserIdResult>> callback) {
        GetSendRequestByUserIdTask task = new GetSendRequestByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetSendRequestByUserIdResult getSendRequestByUserId(GetSendRequestByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSendRequestByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSendRequestByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void sendRequestAsync(SendRequestRequest request, AsyncAction<AsyncResult<SendRequestResult>> callback) {
        SendRequestTask task = new SendRequestTask(request, callback);
        this.session.execute(task);
    }

    public SendRequestResult sendRequest(SendRequestRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.sendRequestAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SendRequestResult)resultAsyncResult[0].getResult();
    }

    public void sendRequestByUserIdAsync(SendRequestByUserIdRequest request, AsyncAction<AsyncResult<SendRequestByUserIdResult>> callback) {
        SendRequestByUserIdTask task = new SendRequestByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SendRequestByUserIdResult sendRequestByUserId(SendRequestByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.sendRequestByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SendRequestByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteRequestAsync(DeleteRequestRequest request, AsyncAction<AsyncResult<DeleteRequestResult>> callback) {
        DeleteRequestTask task = new DeleteRequestTask(request, callback);
        this.session.execute(task);
    }

    public DeleteRequestResult deleteRequest(DeleteRequestRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteRequestAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteRequestResult)resultAsyncResult[0].getResult();
    }

    public void deleteRequestByUserIdAsync(DeleteRequestByUserIdRequest request, AsyncAction<AsyncResult<DeleteRequestByUserIdResult>> callback) {
        DeleteRequestByUserIdTask task = new DeleteRequestByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteRequestByUserIdResult deleteRequestByUserId(DeleteRequestByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteRequestByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteRequestByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeReceiveRequestsAsync(DescribeReceiveRequestsRequest request, AsyncAction<AsyncResult<DescribeReceiveRequestsResult>> callback) {
        DescribeReceiveRequestsTask task = new DescribeReceiveRequestsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeReceiveRequestsResult describeReceiveRequests(DescribeReceiveRequestsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeReceiveRequestsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeReceiveRequestsResult)resultAsyncResult[0].getResult();
    }

    public void describeReceiveRequestsByUserIdAsync(DescribeReceiveRequestsByUserIdRequest request, AsyncAction<AsyncResult<DescribeReceiveRequestsByUserIdResult>> callback) {
        DescribeReceiveRequestsByUserIdTask task = new DescribeReceiveRequestsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeReceiveRequestsByUserIdResult describeReceiveRequestsByUserId(DescribeReceiveRequestsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeReceiveRequestsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeReceiveRequestsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getReceiveRequestAsync(GetReceiveRequestRequest request, AsyncAction<AsyncResult<GetReceiveRequestResult>> callback) {
        GetReceiveRequestTask task = new GetReceiveRequestTask(request, callback);
        this.session.execute(task);
    }

    public GetReceiveRequestResult getReceiveRequest(GetReceiveRequestRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getReceiveRequestAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetReceiveRequestResult)resultAsyncResult[0].getResult();
    }

    public void getReceiveRequestByUserIdAsync(GetReceiveRequestByUserIdRequest request, AsyncAction<AsyncResult<GetReceiveRequestByUserIdResult>> callback) {
        GetReceiveRequestByUserIdTask task = new GetReceiveRequestByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetReceiveRequestByUserIdResult getReceiveRequestByUserId(GetReceiveRequestByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getReceiveRequestByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetReceiveRequestByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void acceptRequestAsync(AcceptRequestRequest request, AsyncAction<AsyncResult<AcceptRequestResult>> callback) {
        AcceptRequestTask task = new AcceptRequestTask(request, callback);
        this.session.execute(task);
    }

    public AcceptRequestResult acceptRequest(AcceptRequestRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.acceptRequestAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AcceptRequestResult)resultAsyncResult[0].getResult();
    }

    public void acceptRequestByUserIdAsync(AcceptRequestByUserIdRequest request, AsyncAction<AsyncResult<AcceptRequestByUserIdResult>> callback) {
        AcceptRequestByUserIdTask task = new AcceptRequestByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public AcceptRequestByUserIdResult acceptRequestByUserId(AcceptRequestByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.acceptRequestByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AcceptRequestByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void rejectRequestAsync(RejectRequestRequest request, AsyncAction<AsyncResult<RejectRequestResult>> callback) {
        RejectRequestTask task = new RejectRequestTask(request, callback);
        this.session.execute(task);
    }

    public RejectRequestResult rejectRequest(RejectRequestRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.rejectRequestAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RejectRequestResult)resultAsyncResult[0].getResult();
    }

    public void rejectRequestByUserIdAsync(RejectRequestByUserIdRequest request, AsyncAction<AsyncResult<RejectRequestByUserIdResult>> callback) {
        RejectRequestByUserIdTask task = new RejectRequestByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public RejectRequestByUserIdResult rejectRequestByUserId(RejectRequestByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.rejectRequestByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RejectRequestByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getPublicProfileAsync(GetPublicProfileRequest request, AsyncAction<AsyncResult<GetPublicProfileResult>> callback) {
        GetPublicProfileTask task = new GetPublicProfileTask(request, callback);
        this.session.execute(task);
    }

    public GetPublicProfileResult getPublicProfile(GetPublicProfileRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getPublicProfileAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetPublicProfileResult)resultAsyncResult[0].getResult();
    }

    class GetPublicProfileTask
    extends Gs2RestSessionTask<GetPublicProfileResult> {
        private GetPublicProfileRequest request;

        public GetPublicProfileTask(GetPublicProfileRequest request, AsyncAction<AsyncResult<GetPublicProfileResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetPublicProfileResult parse(JsonNode data) {
            return GetPublicProfileResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/profile/public";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RejectRequestByUserIdTask
    extends Gs2RestSessionTask<RejectRequestByUserIdResult> {
        private RejectRequestByUserIdRequest request;

        public RejectRequestByUserIdTask(RejectRequestByUserIdRequest request, AsyncAction<AsyncResult<RejectRequestByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RejectRequestByUserIdResult parse(JsonNode data) {
            return RejectRequestByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/inbox/{fromUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{fromUserId}", this.request.getFromUserId() == null || this.request.getFromUserId().length() == 0 ? "null" : String.valueOf(this.request.getFromUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RejectRequestTask
    extends Gs2RestSessionTask<RejectRequestResult> {
        private RejectRequestRequest request;

        public RejectRequestTask(RejectRequestRequest request, AsyncAction<AsyncResult<RejectRequestResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RejectRequestResult parse(JsonNode data) {
            return RejectRequestResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/inbox/{fromUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{fromUserId}", this.request.getFromUserId() == null || this.request.getFromUserId().length() == 0 ? "null" : String.valueOf(this.request.getFromUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class AcceptRequestByUserIdTask
    extends Gs2RestSessionTask<AcceptRequestByUserIdResult> {
        private AcceptRequestByUserIdRequest request;

        public AcceptRequestByUserIdTask(AcceptRequestByUserIdRequest request, AsyncAction<AsyncResult<AcceptRequestByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AcceptRequestByUserIdResult parse(JsonNode data) {
            return AcceptRequestByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/inbox/{fromUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{fromUserId}", this.request.getFromUserId() == null || this.request.getFromUserId().length() == 0 ? "null" : String.valueOf(this.request.getFromUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", AcceptRequestByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class AcceptRequestTask
    extends Gs2RestSessionTask<AcceptRequestResult> {
        private AcceptRequestRequest request;

        public AcceptRequestTask(AcceptRequestRequest request, AsyncAction<AsyncResult<AcceptRequestResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AcceptRequestResult parse(JsonNode data) {
            return AcceptRequestResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/inbox/{fromUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{fromUserId}", this.request.getFromUserId() == null || this.request.getFromUserId().length() == 0 ? "null" : String.valueOf(this.request.getFromUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", AcceptRequestTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetReceiveRequestByUserIdTask
    extends Gs2RestSessionTask<GetReceiveRequestByUserIdResult> {
        private GetReceiveRequestByUserIdRequest request;

        public GetReceiveRequestByUserIdTask(GetReceiveRequestByUserIdRequest request, AsyncAction<AsyncResult<GetReceiveRequestByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetReceiveRequestByUserIdResult parse(JsonNode data) {
            return GetReceiveRequestByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/inbox/{fromUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{fromUserId}", this.request.getFromUserId() == null || this.request.getFromUserId().length() == 0 ? "null" : String.valueOf(this.request.getFromUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetReceiveRequestTask
    extends Gs2RestSessionTask<GetReceiveRequestResult> {
        private GetReceiveRequestRequest request;

        public GetReceiveRequestTask(GetReceiveRequestRequest request, AsyncAction<AsyncResult<GetReceiveRequestResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetReceiveRequestResult parse(JsonNode data) {
            return GetReceiveRequestResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/inbox/{fromUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{fromUserId}", this.request.getFromUserId() == null || this.request.getFromUserId().length() == 0 ? "null" : String.valueOf(this.request.getFromUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeReceiveRequestsByUserIdTask
    extends Gs2RestSessionTask<DescribeReceiveRequestsByUserIdResult> {
        private DescribeReceiveRequestsByUserIdRequest request;

        public DescribeReceiveRequestsByUserIdTask(DescribeReceiveRequestsByUserIdRequest request, AsyncAction<AsyncResult<DescribeReceiveRequestsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeReceiveRequestsByUserIdResult parse(JsonNode data) {
            return DescribeReceiveRequestsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/inbox";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeReceiveRequestsTask
    extends Gs2RestSessionTask<DescribeReceiveRequestsResult> {
        private DescribeReceiveRequestsRequest request;

        public DescribeReceiveRequestsTask(DescribeReceiveRequestsRequest request, AsyncAction<AsyncResult<DescribeReceiveRequestsResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeReceiveRequestsResult parse(JsonNode data) {
            return DescribeReceiveRequestsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/inbox";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteRequestByUserIdTask
    extends Gs2RestSessionTask<DeleteRequestByUserIdResult> {
        private DeleteRequestByUserIdRequest request;

        public DeleteRequestByUserIdTask(DeleteRequestByUserIdRequest request, AsyncAction<AsyncResult<DeleteRequestByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteRequestByUserIdResult parse(JsonNode data) {
            return DeleteRequestByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/sendBox/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteRequestTask
    extends Gs2RestSessionTask<DeleteRequestResult> {
        private DeleteRequestRequest request;

        public DeleteRequestTask(DeleteRequestRequest request, AsyncAction<AsyncResult<DeleteRequestResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteRequestResult parse(JsonNode data) {
            return DeleteRequestResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/sendBox/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class SendRequestByUserIdTask
    extends Gs2RestSessionTask<SendRequestByUserIdResult> {
        private SendRequestByUserIdRequest request;

        public SendRequestByUserIdTask(SendRequestByUserIdRequest request, AsyncAction<AsyncResult<SendRequestByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SendRequestByUserIdResult parse(JsonNode data) {
            return SendRequestByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/sendBox/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", SendRequestByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class SendRequestTask
    extends Gs2RestSessionTask<SendRequestResult> {
        private SendRequestRequest request;

        public SendRequestTask(SendRequestRequest request, AsyncAction<AsyncResult<SendRequestResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SendRequestResult parse(JsonNode data) {
            return SendRequestResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/sendBox/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", SendRequestTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetSendRequestByUserIdTask
    extends Gs2RestSessionTask<GetSendRequestByUserIdResult> {
        private GetSendRequestByUserIdRequest request;

        public GetSendRequestByUserIdTask(GetSendRequestByUserIdRequest request, AsyncAction<AsyncResult<GetSendRequestByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSendRequestByUserIdResult parse(JsonNode data) {
            return GetSendRequestByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/sendBox/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetSendRequestTask
    extends Gs2RestSessionTask<GetSendRequestResult> {
        private GetSendRequestRequest request;

        public GetSendRequestTask(GetSendRequestRequest request, AsyncAction<AsyncResult<GetSendRequestResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSendRequestResult parse(JsonNode data) {
            return GetSendRequestResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/sendBox/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeSendRequestsByUserIdTask
    extends Gs2RestSessionTask<DescribeSendRequestsByUserIdResult> {
        private DescribeSendRequestsByUserIdRequest request;

        public DescribeSendRequestsByUserIdTask(DescribeSendRequestsByUserIdRequest request, AsyncAction<AsyncResult<DescribeSendRequestsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSendRequestsByUserIdResult parse(JsonNode data) {
            return DescribeSendRequestsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/sendBox";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeSendRequestsTask
    extends Gs2RestSessionTask<DescribeSendRequestsResult> {
        private DescribeSendRequestsRequest request;

        public DescribeSendRequestsTask(DescribeSendRequestsRequest request, AsyncAction<AsyncResult<DescribeSendRequestsResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSendRequestsResult parse(JsonNode data) {
            return DescribeSendRequestsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/sendBox";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteFriendByUserIdTask
    extends Gs2RestSessionTask<DeleteFriendByUserIdResult> {
        private DeleteFriendByUserIdRequest request;

        public DeleteFriendByUserIdTask(DeleteFriendByUserIdRequest request, AsyncAction<AsyncResult<DeleteFriendByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteFriendByUserIdResult parse(JsonNode data) {
            return DeleteFriendByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/friend/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteFriendTask
    extends Gs2RestSessionTask<DeleteFriendResult> {
        private DeleteFriendRequest request;

        public DeleteFriendTask(DeleteFriendRequest request, AsyncAction<AsyncResult<DeleteFriendResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteFriendResult parse(JsonNode data) {
            return DeleteFriendResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/friend/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetFriendByUserIdTask
    extends Gs2RestSessionTask<GetFriendByUserIdResult> {
        private GetFriendByUserIdRequest request;

        public GetFriendByUserIdTask(GetFriendByUserIdRequest request, AsyncAction<AsyncResult<GetFriendByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetFriendByUserIdResult parse(JsonNode data) {
            return GetFriendByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/friend/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getWithProfile() != null) {
                queryStrings.add("withProfile=" + String.valueOf(this.request.getWithProfile()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetFriendTask
    extends Gs2RestSessionTask<GetFriendResult> {
        private GetFriendRequest request;

        public GetFriendTask(GetFriendRequest request, AsyncAction<AsyncResult<GetFriendResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetFriendResult parse(JsonNode data) {
            return GetFriendResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/friend/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getWithProfile() != null) {
                queryStrings.add("withProfile=" + String.valueOf(this.request.getWithProfile()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class UnfollowByUserIdTask
    extends Gs2RestSessionTask<UnfollowByUserIdResult> {
        private UnfollowByUserIdRequest request;

        public UnfollowByUserIdTask(UnfollowByUserIdRequest request, AsyncAction<AsyncResult<UnfollowByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnfollowByUserIdResult parse(JsonNode data) {
            return UnfollowByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/follow/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UnfollowTask
    extends Gs2RestSessionTask<UnfollowResult> {
        private UnfollowRequest request;

        public UnfollowTask(UnfollowRequest request, AsyncAction<AsyncResult<UnfollowResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnfollowResult parse(JsonNode data) {
            return UnfollowResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/follow/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class FollowByUserIdTask
    extends Gs2RestSessionTask<FollowByUserIdResult> {
        private FollowByUserIdRequest request;

        public FollowByUserIdTask(FollowByUserIdRequest request, AsyncAction<AsyncResult<FollowByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public FollowByUserIdResult parse(JsonNode data) {
            return FollowByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/follow/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", FollowByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class FollowTask
    extends Gs2RestSessionTask<FollowResult> {
        private FollowRequest request;

        public FollowTask(FollowRequest request, AsyncAction<AsyncResult<FollowResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public FollowResult parse(JsonNode data) {
            return FollowResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/follow/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", FollowTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetFollowByUserIdTask
    extends Gs2RestSessionTask<GetFollowByUserIdResult> {
        private GetFollowByUserIdRequest request;

        public GetFollowByUserIdTask(GetFollowByUserIdRequest request, AsyncAction<AsyncResult<GetFollowByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetFollowByUserIdResult parse(JsonNode data) {
            return GetFollowByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/follow/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getWithProfile() != null) {
                queryStrings.add("withProfile=" + String.valueOf(this.request.getWithProfile()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetFollowTask
    extends Gs2RestSessionTask<GetFollowResult> {
        private GetFollowRequest request;

        public GetFollowTask(GetFollowRequest request, AsyncAction<AsyncResult<GetFollowResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetFollowResult parse(JsonNode data) {
            return GetFollowResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/follow/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getWithProfile() != null) {
                queryStrings.add("withProfile=" + String.valueOf(this.request.getWithProfile()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeFollowsByUserIdTask
    extends Gs2RestSessionTask<DescribeFollowsByUserIdResult> {
        private DescribeFollowsByUserIdRequest request;

        public DescribeFollowsByUserIdTask(DescribeFollowsByUserIdRequest request, AsyncAction<AsyncResult<DescribeFollowsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeFollowsByUserIdResult parse(JsonNode data) {
            return DescribeFollowsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/follow";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getWithProfile() != null) {
                queryStrings.add("withProfile=" + String.valueOf(this.request.getWithProfile()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeFollowsTask
    extends Gs2RestSessionTask<DescribeFollowsResult> {
        private DescribeFollowsRequest request;

        public DescribeFollowsTask(DescribeFollowsRequest request, AsyncAction<AsyncResult<DescribeFollowsResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeFollowsResult parse(JsonNode data) {
            return DescribeFollowsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/follow";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getWithProfile() != null) {
                queryStrings.add("withProfile=" + String.valueOf(this.request.getWithProfile()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class UnregisterBlackListByUserIdTask
    extends Gs2RestSessionTask<UnregisterBlackListByUserIdResult> {
        private UnregisterBlackListByUserIdRequest request;

        public UnregisterBlackListByUserIdTask(UnregisterBlackListByUserIdRequest request, AsyncAction<AsyncResult<UnregisterBlackListByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnregisterBlackListByUserIdResult parse(JsonNode data) {
            return UnregisterBlackListByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/blackList/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UnregisterBlackListTask
    extends Gs2RestSessionTask<UnregisterBlackListResult> {
        private UnregisterBlackListRequest request;

        public UnregisterBlackListTask(UnregisterBlackListRequest request, AsyncAction<AsyncResult<UnregisterBlackListResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnregisterBlackListResult parse(JsonNode data) {
            return UnregisterBlackListResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/blackList/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class RegisterBlackListByUserIdTask
    extends Gs2RestSessionTask<RegisterBlackListByUserIdResult> {
        private RegisterBlackListByUserIdRequest request;

        public RegisterBlackListByUserIdTask(RegisterBlackListByUserIdRequest request, AsyncAction<AsyncResult<RegisterBlackListByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RegisterBlackListByUserIdResult parse(JsonNode data) {
            return RegisterBlackListByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/blackList/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", RegisterBlackListByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RegisterBlackListTask
    extends Gs2RestSessionTask<RegisterBlackListResult> {
        private RegisterBlackListRequest request;

        public RegisterBlackListTask(RegisterBlackListRequest request, AsyncAction<AsyncResult<RegisterBlackListResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RegisterBlackListResult parse(JsonNode data) {
            return RegisterBlackListResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/blackList/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", RegisterBlackListTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeBlackListByUserIdTask
    extends Gs2RestSessionTask<DescribeBlackListByUserIdResult> {
        private DescribeBlackListByUserIdRequest request;

        public DescribeBlackListByUserIdTask(DescribeBlackListByUserIdRequest request, AsyncAction<AsyncResult<DescribeBlackListByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeBlackListByUserIdResult parse(JsonNode data) {
            return DescribeBlackListByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/blackList";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeBlackListTask
    extends Gs2RestSessionTask<DescribeBlackListResult> {
        private DescribeBlackListRequest request;

        public DescribeBlackListTask(DescribeBlackListRequest request, AsyncAction<AsyncResult<DescribeBlackListResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeBlackListResult parse(JsonNode data) {
            return DescribeBlackListResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/blackList";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeFriendsByUserIdTask
    extends Gs2RestSessionTask<DescribeFriendsByUserIdResult> {
        private DescribeFriendsByUserIdRequest request;

        public DescribeFriendsByUserIdTask(DescribeFriendsByUserIdRequest request, AsyncAction<AsyncResult<DescribeFriendsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeFriendsByUserIdResult parse(JsonNode data) {
            return DescribeFriendsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/friend";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getWithProfile() != null) {
                queryStrings.add("withProfile=" + String.valueOf(this.request.getWithProfile()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeFriendsTask
    extends Gs2RestSessionTask<DescribeFriendsResult> {
        private DescribeFriendsRequest request;

        public DescribeFriendsTask(DescribeFriendsRequest request, AsyncAction<AsyncResult<DescribeFriendsResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeFriendsResult parse(JsonNode data) {
            return DescribeFriendsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/friend";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getWithProfile() != null) {
                queryStrings.add("withProfile=" + String.valueOf(this.request.getWithProfile()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteProfileByUserIdTask
    extends Gs2RestSessionTask<DeleteProfileByUserIdResult> {
        private DeleteProfileByUserIdRequest request;

        public DeleteProfileByUserIdTask(DeleteProfileByUserIdRequest request, AsyncAction<AsyncResult<DeleteProfileByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteProfileByUserIdResult parse(JsonNode data) {
            return DeleteProfileByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/profile";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateProfileByUserIdTask
    extends Gs2RestSessionTask<UpdateProfileByUserIdResult> {
        private UpdateProfileByUserIdRequest request;

        public UpdateProfileByUserIdTask(UpdateProfileByUserIdRequest request, AsyncAction<AsyncResult<UpdateProfileByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateProfileByUserIdResult parse(JsonNode data) {
            return UpdateProfileByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/profile";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("publicProfile", UpdateProfileByUserIdTask.this.request.getPublicProfile());
                    this.put("followerProfile", UpdateProfileByUserIdTask.this.request.getFollowerProfile());
                    this.put("friendProfile", UpdateProfileByUserIdTask.this.request.getFriendProfile());
                    this.put("contextStack", UpdateProfileByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateProfileTask
    extends Gs2RestSessionTask<UpdateProfileResult> {
        private UpdateProfileRequest request;

        public UpdateProfileTask(UpdateProfileRequest request, AsyncAction<AsyncResult<UpdateProfileResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateProfileResult parse(JsonNode data) {
            return UpdateProfileResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/profile";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("publicProfile", UpdateProfileTask.this.request.getPublicProfile());
                    this.put("followerProfile", UpdateProfileTask.this.request.getFollowerProfile());
                    this.put("friendProfile", UpdateProfileTask.this.request.getFriendProfile());
                    this.put("contextStack", UpdateProfileTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetProfileByUserIdTask
    extends Gs2RestSessionTask<GetProfileByUserIdResult> {
        private GetProfileByUserIdRequest request;

        public GetProfileByUserIdTask(GetProfileByUserIdRequest request, AsyncAction<AsyncResult<GetProfileByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetProfileByUserIdResult parse(JsonNode data) {
            return GetProfileByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/profile";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetProfileTask
    extends Gs2RestSessionTask<GetProfileResult> {
        private GetProfileRequest request;

        public GetProfileTask(GetProfileRequest request, AsyncAction<AsyncResult<GetProfileResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetProfileResult parse(JsonNode data) {
            return GetProfileResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/profile";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("followScript", UpdateNamespaceTask.this.request.getFollowScript() != null ? UpdateNamespaceTask.this.request.getFollowScript().toJson() : null);
                    this.put("unfollowScript", UpdateNamespaceTask.this.request.getUnfollowScript() != null ? UpdateNamespaceTask.this.request.getUnfollowScript().toJson() : null);
                    this.put("sendRequestScript", UpdateNamespaceTask.this.request.getSendRequestScript() != null ? UpdateNamespaceTask.this.request.getSendRequestScript().toJson() : null);
                    this.put("cancelRequestScript", UpdateNamespaceTask.this.request.getCancelRequestScript() != null ? UpdateNamespaceTask.this.request.getCancelRequestScript().toJson() : null);
                    this.put("acceptRequestScript", UpdateNamespaceTask.this.request.getAcceptRequestScript() != null ? UpdateNamespaceTask.this.request.getAcceptRequestScript().toJson() : null);
                    this.put("rejectRequestScript", UpdateNamespaceTask.this.request.getRejectRequestScript() != null ? UpdateNamespaceTask.this.request.getRejectRequestScript().toJson() : null);
                    this.put("deleteFriendScript", UpdateNamespaceTask.this.request.getDeleteFriendScript() != null ? UpdateNamespaceTask.this.request.getDeleteFriendScript().toJson() : null);
                    this.put("updateProfileScript", UpdateNamespaceTask.this.request.getUpdateProfileScript() != null ? UpdateNamespaceTask.this.request.getUpdateProfileScript().toJson() : null);
                    this.put("followNotification", UpdateNamespaceTask.this.request.getFollowNotification() != null ? UpdateNamespaceTask.this.request.getFollowNotification().toJson() : null);
                    this.put("receiveRequestNotification", UpdateNamespaceTask.this.request.getReceiveRequestNotification() != null ? UpdateNamespaceTask.this.request.getReceiveRequestNotification().toJson() : null);
                    this.put("acceptRequestNotification", UpdateNamespaceTask.this.request.getAcceptRequestNotification() != null ? UpdateNamespaceTask.this.request.getAcceptRequestNotification().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("followScript", CreateNamespaceTask.this.request.getFollowScript() != null ? CreateNamespaceTask.this.request.getFollowScript().toJson() : null);
                    this.put("unfollowScript", CreateNamespaceTask.this.request.getUnfollowScript() != null ? CreateNamespaceTask.this.request.getUnfollowScript().toJson() : null);
                    this.put("sendRequestScript", CreateNamespaceTask.this.request.getSendRequestScript() != null ? CreateNamespaceTask.this.request.getSendRequestScript().toJson() : null);
                    this.put("cancelRequestScript", CreateNamespaceTask.this.request.getCancelRequestScript() != null ? CreateNamespaceTask.this.request.getCancelRequestScript().toJson() : null);
                    this.put("acceptRequestScript", CreateNamespaceTask.this.request.getAcceptRequestScript() != null ? CreateNamespaceTask.this.request.getAcceptRequestScript().toJson() : null);
                    this.put("rejectRequestScript", CreateNamespaceTask.this.request.getRejectRequestScript() != null ? CreateNamespaceTask.this.request.getRejectRequestScript().toJson() : null);
                    this.put("deleteFriendScript", CreateNamespaceTask.this.request.getDeleteFriendScript() != null ? CreateNamespaceTask.this.request.getDeleteFriendScript().toJson() : null);
                    this.put("updateProfileScript", CreateNamespaceTask.this.request.getUpdateProfileScript() != null ? CreateNamespaceTask.this.request.getUpdateProfileScript().toJson() : null);
                    this.put("followNotification", CreateNamespaceTask.this.request.getFollowNotification() != null ? CreateNamespaceTask.this.request.getFollowNotification().toJson() : null);
                    this.put("receiveRequestNotification", CreateNamespaceTask.this.request.getReceiveRequestNotification() != null ? CreateNamespaceTask.this.request.getReceiveRequestNotification().toJson() : null);
                    this.put("acceptRequestNotification", CreateNamespaceTask.this.request.getAcceptRequestNotification() != null ? CreateNamespaceTask.this.request.getAcceptRequestNotification().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2FriendRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "friend").replace("{region}", Gs2FriendRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

