/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.NamespaceDomain;
import io.gs2.formation.model.MoldModelMaster;
import io.gs2.formation.request.DeleteMoldModelMasterRequest;
import io.gs2.formation.request.GetMoldModelMasterRequest;
import io.gs2.formation.request.UpdateMoldModelMasterRequest;
import io.gs2.formation.result.DeleteMoldModelMasterResult;
import io.gs2.formation.result.GetMoldModelMasterResult;
import io.gs2.formation.result.UpdateMoldModelMasterResult;

public class MoldModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final String moldName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getMoldName() {
        return this.moldName;
    }

    public MoldModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String moldName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.moldName = moldName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MoldModelMaster");
    }

    private MoldModelMaster get(GetMoldModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMoldName(this.moldName);
        GetMoldModelMasterResult result = this.client.getMoldModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MoldModelMasterDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public MoldModelMasterDomain update(UpdateMoldModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMoldName(this.moldName);
        UpdateMoldModelMasterResult result = this.client.updateMoldModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MoldModelMasterDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MoldModelMasterDomain domain = this;
        return domain;
    }

    public MoldModelMasterDomain delete(DeleteMoldModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMoldName(this.moldName);
        DeleteMoldModelMasterResult result = null;
        try {
            result = this.client.deleteMoldModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MoldModelMasterDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), MoldModelMaster.class);
        MoldModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String moldName, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, moldName, childType);
    }

    public static String createCacheKey(String moldName) {
        return String.join((CharSequence)":", moldName);
    }

    public MoldModelMaster model() {
        MoldModelMaster value = this.cache.get(this.parentKey, MoldModelMasterDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), MoldModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetMoldModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MoldModelMasterDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), MoldModelMaster.class);
            }
            value = this.cache.get(this.parentKey, MoldModelMasterDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), MoldModelMaster.class);
        }
        return value;
    }
}

