/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.FormModelDomain;
import io.gs2.formation.domain.model.NamespaceDomain;
import io.gs2.formation.model.MoldModel;
import io.gs2.formation.request.GetMoldModelRequest;
import io.gs2.formation.result.GetMoldModelResult;

public class MoldModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final String moldName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getMoldName() {
        return this.moldName;
    }

    public MoldModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String moldName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.moldName = moldName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MoldModel");
    }

    private MoldModel get(GetMoldModelRequest request) {
        request.withNamespaceName(this.namespaceName).withMoldName(this.moldName);
        GetMoldModelResult result = this.client.getMoldModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FormModelDomain formModel(String formModelName) {
        return new FormModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.moldName, formModelName);
    }

    public static String createCacheParentKey(String namespaceName, String moldName, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, moldName, childType);
    }

    public static String createCacheKey(String moldName) {
        return String.join((CharSequence)":", moldName);
    }

    public MoldModel model() {
        MoldModel value = this.cache.get(this.parentKey, MoldModelDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), MoldModel.class);
        if (value == null) {
            try {
                this.get(new GetMoldModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MoldModelDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), MoldModel.class);
            }
            value = this.cache.get(this.parentKey, MoldModelDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), MoldModel.class);
        }
        return value;
    }
}

