/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.iterator.DescribeFormsByUserIdIterator;
import io.gs2.formation.domain.model.FormDomain;
import io.gs2.formation.domain.model.MoldModelDomain;
import io.gs2.formation.domain.model.UserDomain;
import io.gs2.formation.model.Mold;
import io.gs2.formation.request.AddMoldCapacityByUserIdRequest;
import io.gs2.formation.request.DeleteMoldByUserIdRequest;
import io.gs2.formation.request.GetMoldByUserIdRequest;
import io.gs2.formation.request.SetMoldCapacityByUserIdRequest;
import io.gs2.formation.result.AddMoldCapacityByUserIdResult;
import io.gs2.formation.result.DeleteMoldByUserIdResult;
import io.gs2.formation.result.GetMoldByUserIdResult;
import io.gs2.formation.result.SetMoldCapacityByUserIdResult;

public class MoldDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String moldName;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMoldName() {
        return this.moldName;
    }

    public MoldDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String moldName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.moldName = moldName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Mold");
    }

    private Mold get(GetMoldByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMoldName(this.moldName);
        GetMoldByUserIdResult result = this.client.getMoldByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public MoldDomain setCapacity(SetMoldCapacityByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMoldName(this.moldName);
        SetMoldCapacityByUserIdResult result = this.client.setMoldCapacityByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MoldDomain domain = this;
        return domain;
    }

    public MoldDomain addCapacity(AddMoldCapacityByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMoldName(this.moldName);
        AddMoldCapacityByUserIdResult result = this.client.addMoldCapacityByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MoldDomain domain = this;
        return domain;
    }

    public MoldDomain delete(DeleteMoldByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMoldName(this.moldName);
        DeleteMoldByUserIdResult result = null;
        try {
            result = this.client.deleteMoldByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), Mold.class);
        MoldDomain domain = this;
        return domain;
    }

    public DescribeFormsByUserIdIterator forms() {
        return new DescribeFormsByUserIdIterator(this.cache, this.client, this.namespaceName, this.moldName, this.userId);
    }

    public FormDomain form(Integer index) {
        return new FormDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, this.moldName, index);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String moldName, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, userId, moldName, childType);
    }

    public static String createCacheKey(String moldName) {
        return String.join((CharSequence)":", moldName);
    }

    public Mold model() {
        Mold value = this.cache.get(this.parentKey, MoldDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), Mold.class);
        if (value == null) {
            try {
                this.get(new GetMoldByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MoldDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), Mold.class);
            }
            value = this.cache.get(this.parentKey, MoldDomain.createCacheKey(this.getMoldName() != null ? this.getMoldName().toString() : null), Mold.class);
        }
        return value;
    }
}

