/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.NamespaceDomain;
import io.gs2.formation.model.FormModelMaster;
import io.gs2.formation.request.DeleteFormModelMasterRequest;
import io.gs2.formation.request.GetFormModelMasterRequest;
import io.gs2.formation.request.UpdateFormModelMasterRequest;
import io.gs2.formation.result.DeleteFormModelMasterResult;
import io.gs2.formation.result.GetFormModelMasterResult;
import io.gs2.formation.result.UpdateFormModelMasterResult;

public class FormModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final String formModelName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getFormModelName() {
        return this.formModelName;
    }

    public FormModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String formModelName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.formModelName = formModelName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "FormModelMaster");
    }

    private FormModelMaster get(GetFormModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withFormModelName(this.formModelName);
        GetFormModelMasterResult result = this.client.getFormModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FormModelMasterDomain.createCacheKey(request.getFormModelName() != null ? request.getFormModelName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FormModelMasterDomain update(UpdateFormModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withFormModelName(this.formModelName);
        UpdateFormModelMasterResult result = this.client.updateFormModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FormModelMasterDomain.createCacheKey(request.getFormModelName() != null ? request.getFormModelName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FormModelMasterDomain domain = this;
        return domain;
    }

    public FormModelMasterDomain delete(DeleteFormModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withFormModelName(this.formModelName);
        DeleteFormModelMasterResult result = null;
        try {
            result = this.client.deleteFormModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FormModelMasterDomain.createCacheKey(request.getFormModelName() != null ? request.getFormModelName().toString() : null), FormModelMaster.class);
        FormModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String formModelName, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, formModelName, childType);
    }

    public static String createCacheKey(String formModelName) {
        return String.join((CharSequence)":", formModelName);
    }

    public FormModelMaster model() {
        FormModelMaster value = this.cache.get(this.parentKey, FormModelMasterDomain.createCacheKey(this.getFormModelName() != null ? this.getFormModelName().toString() : null), FormModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetFormModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, FormModelMasterDomain.createCacheKey(this.getFormModelName() != null ? this.getFormModelName().toString() : null), FormModelMaster.class);
            }
            value = this.cache.get(this.parentKey, FormModelMasterDomain.createCacheKey(this.getFormModelName() != null ? this.getFormModelName().toString() : null), FormModelMaster.class);
        }
        return value;
    }
}

