/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.MoldModelDomain;
import io.gs2.formation.model.FormModel;

public class FormModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final String moldName;
    private final String formModelName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getMoldName() {
        return this.moldName;
    }

    public String getFormModelName() {
        return this.formModelName;
    }

    public FormModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String moldName, String formModelName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.moldName = moldName;
        this.formModelName = formModelName;
        this.parentKey = MoldModelDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.moldName != null ? this.moldName.toString() : null, "FormModel");
    }

    public static String createCacheParentKey(String namespaceName, String moldName, String formModelName, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, moldName, formModelName, childType);
    }

    public static String createCacheKey(String formModelName) {
        return String.join((CharSequence)":", formModelName);
    }

    public FormModel model() {
        FormModel value = this.cache.get(this.parentKey, FormModelDomain.createCacheKey(this.getFormModelName() != null ? this.getFormModelName().toString() : null), FormModel.class);
        return value;
    }
}

