/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.FormModelDomain;
import io.gs2.formation.domain.model.MoldDomain;
import io.gs2.formation.domain.model.MoldModelDomain;
import io.gs2.formation.model.Form;
import io.gs2.formation.request.AcquireActionsToFormPropertiesRequest;
import io.gs2.formation.request.DeleteFormByUserIdRequest;
import io.gs2.formation.request.GetFormByUserIdRequest;
import io.gs2.formation.request.GetFormWithSignatureByUserIdRequest;
import io.gs2.formation.request.SetFormByUserIdRequest;
import io.gs2.formation.result.AcquireActionsToFormPropertiesResult;
import io.gs2.formation.result.DeleteFormByUserIdResult;
import io.gs2.formation.result.GetFormByUserIdResult;
import io.gs2.formation.result.GetFormWithSignatureByUserIdResult;
import io.gs2.formation.result.SetFormByUserIdResult;

public class FormDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String moldName;
    private final Integer index;
    private final String parentKey;
    String body;
    String signature;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMoldName() {
        return this.moldName;
    }

    public Integer getIndex() {
        return this.index;
    }

    public FormDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String moldName, Integer index) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.moldName = moldName;
        this.index = index;
        this.parentKey = MoldDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.moldName != null ? this.moldName.toString() : null, "Form");
    }

    private Form get(GetFormByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMoldName(this.moldName).withIndex(this.index);
        GetFormByUserIdResult result = this.client.getFormByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FormDomain.createCacheKey(request.getIndex() != null ? request.getIndex().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMold() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMold(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getFormModel() != null) {
            this.cache.put(this.parentKey, FormModelDomain.createCacheKey(result.getFormModel().getName() != null ? result.getFormModel().getName().toString() : null), result.getFormModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FormDomain getWithSignature(GetFormWithSignatureByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMoldName(this.moldName).withIndex(this.index);
        GetFormWithSignatureByUserIdResult result = this.client.getFormWithSignatureByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FormDomain.createCacheKey(request.getIndex() != null ? request.getIndex().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMold() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMold(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getFormModel() != null) {
            this.cache.put(this.parentKey, FormModelDomain.createCacheKey(result.getFormModel().getName() != null ? result.getFormModel().getName().toString() : null), result.getFormModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FormDomain domain = this;
        domain.body = result.getBody();
        domain.signature = result.getSignature();
        return domain;
    }

    public FormDomain set(SetFormByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMoldName(this.moldName).withIndex(this.index);
        SetFormByUserIdResult result = this.client.setFormByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FormDomain.createCacheKey(request.getIndex() != null ? request.getIndex().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMold() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMold(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getFormModel() != null) {
            this.cache.put(this.parentKey, FormModelDomain.createCacheKey(result.getFormModel().getName() != null ? result.getFormModel().getName().toString() : null), result.getFormModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FormDomain domain = this;
        return domain;
    }

    public StampSheetDomain acquireActionsToProperties(AcquireActionsToFormPropertiesRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMoldName(this.moldName).withIndex(this.index);
        AcquireActionsToFormPropertiesResult result = this.client.acquireActionsToFormProperties(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FormDomain.createCacheKey(request.getIndex() != null ? request.getIndex().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMold() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMold(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public FormDomain delete(DeleteFormByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMoldName(this.moldName).withIndex(this.index);
        DeleteFormByUserIdResult result = null;
        try {
            result = this.client.deleteFormByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FormDomain.createCacheKey(request.getIndex() != null ? request.getIndex().toString() : null), Form.class);
        FormDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String moldName, String index, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, userId, moldName, index, childType);
    }

    public static String createCacheKey(String index) {
        return String.join((CharSequence)":", index);
    }

    public Form model() {
        Form value = this.cache.get(this.parentKey, FormDomain.createCacheKey(this.getIndex() != null ? this.getIndex().toString() : null), Form.class);
        if (value == null) {
            try {
                this.get(new GetFormByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, FormDomain.createCacheKey(this.getIndex() != null ? this.getIndex().toString() : null), Form.class);
            }
            value = this.cache.get(this.parentKey, FormDomain.createCacheKey(this.getIndex() != null ? this.getIndex().toString() : null), Form.class);
        }
        return value;
    }
}

