/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.FormDomain;
import io.gs2.formation.domain.model.FormModelDomain;
import io.gs2.formation.domain.model.MoldDomain;
import io.gs2.formation.domain.model.MoldModelDomain;
import io.gs2.formation.model.Form;
import io.gs2.formation.request.DeleteFormRequest;
import io.gs2.formation.request.GetFormRequest;
import io.gs2.formation.request.GetFormWithSignatureRequest;
import io.gs2.formation.request.SetFormWithSignatureRequest;
import io.gs2.formation.result.DeleteFormResult;
import io.gs2.formation.result.GetFormResult;
import io.gs2.formation.result.GetFormWithSignatureResult;
import io.gs2.formation.result.SetFormWithSignatureResult;

public class FormAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String moldName;
    private final Integer index;
    private final String parentKey;
    String body;
    String signature;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getMoldName() {
        return this.moldName;
    }

    public Integer getIndex() {
        return this.index;
    }

    public FormAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String moldName, Integer index) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.moldName = moldName;
        this.index = index;
        this.parentKey = MoldDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, this.moldName != null ? this.moldName.toString() : null, "Form");
    }

    private Form get(GetFormRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMoldName(this.moldName).withIndex(this.index);
        GetFormResult result = this.client.getForm(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FormDomain.createCacheKey(request.getIndex() != null ? request.getIndex().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMold() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMold(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getFormModel() != null) {
            this.cache.put(this.parentKey, FormModelDomain.createCacheKey(result.getFormModel().getName() != null ? result.getFormModel().getName().toString() : null), result.getFormModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public FormAccessTokenDomain getWithSignature(GetFormWithSignatureRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMoldName(this.moldName).withIndex(this.index);
        GetFormWithSignatureResult result = this.client.getFormWithSignature(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FormDomain.createCacheKey(request.getIndex() != null ? request.getIndex().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMold() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMold(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getFormModel() != null) {
            this.cache.put(this.parentKey, FormModelDomain.createCacheKey(result.getFormModel().getName() != null ? result.getFormModel().getName().toString() : null), result.getFormModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FormAccessTokenDomain domain = this;
        domain.body = result.getBody();
        domain.signature = result.getSignature();
        return domain;
    }

    public FormAccessTokenDomain setWithSignature(SetFormWithSignatureRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMoldName(this.moldName).withIndex(this.index);
        SetFormWithSignatureResult result = this.client.setFormWithSignature(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, FormDomain.createCacheKey(request.getIndex() != null ? request.getIndex().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMold() != null) {
            this.cache.put(this.parentKey, MoldDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMold(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getMoldModel() != null) {
            this.cache.put(this.parentKey, MoldModelDomain.createCacheKey(request.getMoldName() != null ? request.getMoldName().toString() : null), result.getMoldModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getFormModel() != null) {
            this.cache.put(this.parentKey, FormModelDomain.createCacheKey(result.getFormModel().getName() != null ? result.getFormModel().getName().toString() : null), result.getFormModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        FormAccessTokenDomain domain = this;
        return domain;
    }

    public FormAccessTokenDomain delete(DeleteFormRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withMoldName(this.moldName).withIndex(this.index);
        DeleteFormResult result = null;
        try {
            result = this.client.deleteForm(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, FormDomain.createCacheKey(request.getIndex() != null ? request.getIndex().toString() : null), Form.class);
        FormAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String moldName, String index, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, userId, moldName, index, childType);
    }

    public static String createCacheKey(String index) {
        return String.join((CharSequence)":", index);
    }

    public Form model() {
        Form value = this.cache.get(this.parentKey, FormDomain.createCacheKey(this.getIndex() != null ? this.getIndex().toString() : null), Form.class);
        if (value == null) {
            try {
                this.get(new GetFormRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, FormDomain.createCacheKey(this.getIndex() != null ? this.getIndex().toString() : null), Form.class);
            }
            value = this.cache.get(this.parentKey, FormDomain.createCacheKey(this.getIndex() != null ? this.getIndex().toString() : null), Form.class);
        }
        return value;
    }
}

