/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.NamespaceDomain;
import io.gs2.formation.model.CurrentFormMaster;
import io.gs2.formation.request.ExportMasterRequest;
import io.gs2.formation.request.GetCurrentFormMasterRequest;
import io.gs2.formation.request.UpdateCurrentFormMasterFromGitHubRequest;
import io.gs2.formation.request.UpdateCurrentFormMasterRequest;
import io.gs2.formation.result.ExportMasterResult;
import io.gs2.formation.result.GetCurrentFormMasterResult;
import io.gs2.formation.result.UpdateCurrentFormMasterFromGitHubResult;
import io.gs2.formation.result.UpdateCurrentFormMasterResult;

public class CurrentFormMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentFormMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentFormMaster");
    }

    public CurrentFormMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentFormMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentFormMasterDomain domain = this;
        return domain;
    }

    private CurrentFormMaster get(GetCurrentFormMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentFormMasterResult result = this.client.getCurrentFormMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentFormMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentFormMasterDomain update(UpdateCurrentFormMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentFormMasterResult result = this.client.updateCurrentFormMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentFormMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentFormMasterDomain domain = this;
        return domain;
    }

    public CurrentFormMasterDomain updateFromGitHub(UpdateCurrentFormMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentFormMasterFromGitHubResult result = this.client.updateCurrentFormMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentFormMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentFormMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "formation", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentFormMaster model() {
        CurrentFormMaster value = this.cache.get(this.parentKey, CurrentFormMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentFormMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentFormMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentFormMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentFormMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentFormMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentFormMaster.class);
        }
        return value;
    }
}

