/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.MoldDomain;
import io.gs2.formation.domain.model.UserDomain;
import io.gs2.formation.model.Mold;
import io.gs2.formation.request.DescribeMoldsRequest;
import io.gs2.formation.result.DescribeMoldsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeMoldsIterator
implements Iterator<Mold>,
Iterable<Mold> {
    CacheDatabase cache;
    Gs2FormationRestClient client;
    String namespaceName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<Mold> result;
    Integer fetchSize;

    public DescribeMoldsIterator(CacheDatabase cache, Gs2FormationRestClient client, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Mold>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Mold");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Mold.class)) {
            this.result = this.cache.list(parentKey, Mold.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeMoldsResult r = this.client.describeMolds(new DescribeMoldsRequest().withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Mold item : this.result) {
                this.cache.put(parentKey, MoldDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Mold.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Mold next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Mold ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Mold> iterator() {
        return this;
    }
}

