/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.model.FormModelMasterDomain;
import io.gs2.formation.domain.model.NamespaceDomain;
import io.gs2.formation.model.FormModelMaster;
import io.gs2.formation.request.DescribeFormModelMastersRequest;
import io.gs2.formation.result.DescribeFormModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeFormModelMastersIterator
implements Iterator<FormModelMaster>,
Iterable<FormModelMaster> {
    CacheDatabase cache;
    Gs2FormationRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<FormModelMaster> result;
    Integer fetchSize;

    public DescribeFormModelMastersIterator(CacheDatabase cache, Gs2FormationRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<FormModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "FormModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, FormModelMaster.class)) {
            this.result = this.cache.list(parentKey, FormModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeFormModelMastersResult r = this.client.describeFormModelMasters(new DescribeFormModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (FormModelMaster item : this.result) {
                this.cache.put(parentKey, FormModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, FormModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public FormModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        FormModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<FormModelMaster> iterator() {
        return this;
    }
}

